package de.chiflux.tesla.api;

/**
 * Selected data of the vehicleData API
 * @param id_s id_s
 * @param state state
 * @param vin vin
 * @param drive_state drive_state
 * @param charge_state charge_state
 * @param vehicle_config vehicle_config
 * @param vehicle_state vehicle_state
 */
public record FullVehicleData(
        String id_s, String state, String vin,
        DriveState drive_state, ChargeState charge_state,
        VehicleConfig vehicle_config, VehicleState vehicle_state

) {

    public FullVehicleData withDriveState(DriveState drive_state) {
        return new FullVehicleData(this.id_s, this.state, this.vin, drive_state, this.charge_state, this.vehicle_config, this.vehicle_state);
    }

}
