package de.chiflux.tesla;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

/**
 * Simple Tesla API Data Logger
 */
public class TeslaApiLogger {

    /**
     * Start the data logger
     * @param args args
     * @throws IOException thrown in exception case
     * @throws InterruptedException thrown in exception case
     */
    public static void main(String[] args) throws IOException, InterruptedException {
        TeslaApiService teslaApiService = TeslaApiService.getInstance();
        teslaApiService.startService();
        int available = System.in.available();
        while (available == 0) {
            StateChangeInfo stateChangeInfo = teslaApiService.STATE_CHANGE_INFO_QUEUE.poll(1, TimeUnit.SECONDS);
            if (stateChangeInfo!=null) {
                System.out.println(stateChangeInfo);
            }
            available = System.in.available();
        }
        teslaApiService.endService();
    }


}
