package de.chiflux.tesla;

import de.chiflux.tesla.api.FullVehicleData;
import de.chiflux.tesla.api.VehiclesResponse;

/**
 * A thin wrapper around the Tesla API functionality supporting charging.
 */
public interface TeslaApi {

    /**
     * Start charging
     * @param id_s id of the vehicle
     * @return true if successful
     */
    Boolean startCharge(String id_s);

    /**
     * Stop charging
     * @param id_s id of the vehicle
     * @return true if successful
     */
    Boolean stopCharge(String id_s);

    /**
     * Set the charge limit
     * @param id_s id of the vehicle
     * @param chargeLimit charge limit in percent
     * @return true if successful
     */
    Boolean setChargeLimit(String id_s, int chargeLimit);

    /**
     * Wake up the vehicle
     * @param id_s id of the vehicle
     * @return true if successful
     */
    Boolean wakeUp(String id_s);

    /**
     * Full vehicle data consists of charge state, drive state, vehicle config vehicle state and general information.
     * Should implement a grace period if the vehicle is parked and locked to give the vehicle a change to sleep.
     * @param id_s id of the vehicle
     * @return Full vehicle data or null
     */
    FullVehicleData getFullVehicleData(String id_s);

    /**
     * All vehicles associated with the account
     * @return All vehicles associated with the account or null
     */
    VehiclesResponse getVehicles();

    /**
     * Refresh the access token.
     */
    void refreshToken();

    /**
     * Get the Live API.
     * @return the Live API
     */
    static TeslaApi getLiveApi() {
        return new TeslaLiveApi();
    }

}
