package de.chiflux.tesla;

/**
 * Constants of the Tesla API
 */
public interface TeslaApiDefines {

    /**
     * The general state of the vehicles API can be one of these states.
     */
    enum TESLA_STATE {
        /**
         * vehicle is asleep
         */
        asleep,
        /**
         * vehicle is online
         */
        online,
        /**
         * vehicle is offline
         */
        offline,
        /**
         * vehicle is updating
         */
        updating
    }

    /**
     * The charge state of the vehicles API can be one of these states.
     *     Charging: The vehicle is currently charging.
     *     Complete: The vehicle has completed charging.
     *     Disconnected: There is currently no charger connected to the vehicle.
     *     Stopped: The vehicle was charging but has since stopped.
     *     NoPower: There is a charger connected, but it's not delivering power.
     *     Starting: The charging process is starting.
     */
    enum CHARGE_STATE {
        /**
         * The vehicle is currently charging.
         */
        Charging,
        /**
         * Complete: The vehicle has completed charging.
         */
        Complete,
        /**
         * Disconnected: There is currently no charger connected to the vehicle.
         */
        Disconnected,
        /**
         * Stopped: The vehicle was charging but has since stopped.
         */
        Stopped,
        /**
         * NoPower: There is a charger connected, but it's not delivering power.
         */
        NoPower,
        /**
         * Starting: The charging process is starting.
         */
        Starting
    }

}
