package de.chiflux.tesla;

import java.math.BigDecimal;

/**
 * User-friendly data selection of vehicles and vehicleData information
 * @param id id
 * @param vin vin
 * @param locked locked
 * @param carApiVersion carApiVersion
 * @param carVersion carVersion
 * @param odometer odometer
 * @param isUserPresent isUserPresent
 * @param carSpecialType carSpecialType
 * @param carType carType
 * @param trimBadging trimBadging
 * @param utcOffset utcOffset
 * @param chargingState chargingState
 * @param batteryLevel batteryLevel
 * @param chargeLimitSoc chargeLimitSoc
 * @param timeToFullCharge timeToFullCharge
 * @param batteryRange batteryRange
 * @param estimatedBatteryRange estimatedBatteryRange
 * @param chargePortDoorOpen chargePortDoorOpen
 * @param usableBatteryLevel usableBatteryLevel
 * @param heading heading
 * @param shiftState shiftState
 * @param latitude latitude
 * @param longitude longitude
 * @param power power
 * @param speed speed
 * @param batterySize batterySize
 * @param simpleCarVersion simpleCarVersion
 */
public record ExtendedVehicleInfo(
        String id,
        String vin, Boolean locked, Integer carApiVersion,
        String carVersion, BigDecimal odometer, Boolean isUserPresent, String carSpecialType,
        String carType, String trimBadging, Integer utcOffset, String chargingState, Integer batteryLevel,
        Integer chargeLimitSoc, Double timeToFullCharge,
        BigDecimal batteryRange, BigDecimal estimatedBatteryRange,
        Boolean chargePortDoorOpen,
        Integer usableBatteryLevel, Integer heading, String shiftState, Double latitude,
        Double longitude, Integer power, BigDecimal speed, Integer batterySize,
        String simpleCarVersion
) implements VehicleInfo {

}
