package de.chiflux.tesla.api;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * The TokenRefreshResponse record, which encapsulates data about a refreshed token.
 * @param access_token access_token
 * @param refresh_token refresh_token
 * @param id_token id_token
 * @param expires_in expires_in
 * @param token_type token_type
 */
public record TokenRefreshResponse(
        String access_token,
        String refresh_token,
        String id_token,
        Integer expires_in,
        String token_type) {

    /**
     * Calculates the expiration time of the access token in milliseconds.
     *
     * @return The expiration time in milliseconds.
     */
    @JsonIgnore
    public long expires() {
        return System.currentTimeMillis() + expires_in() * 1000L;
    }

}