package de.chiflux.tesla;

/**
 * TeslaToken
 * @param accessToken accessToken
 * @param expirationDate expirationDate
 */
public record TeslaToken(String accessToken, long expirationDate) {

    /**
     * Test a token for validity
     * @return true if valid
     */
    boolean isValid() {
        return expirationDate - System.currentTimeMillis() >= 300;
    }

    /**
     * Test if a token is expired
     * @return true if expired
     */
    boolean isExpired() {
        return expirationDate-System.currentTimeMillis()<0;
    }

}
