/*
 * Decompiled with CFR 0.152.
 */
package entsoe;

import entsoe.ApiRateLimiter;
import entsoe.EntsoeDate;
import entsoe.EntsoeDefines;
import entsoe.EntsoeResolution;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EntsoeClient
implements EntsoeDefines {
    private static final Logger LOGGER = Logger.getLogger(EntsoeClient.class.getName());
    private static final String apiUrl = "https://web-api.tp.entsoe.eu/api";
    private static final String documentType = "A44";
    private static final String in_Domain = "10Y1001A1001A82H";
    private static final String out_Domain = "10Y1001A1001A82H";
    private final ApiRateLimiter apiRateLimiter = new ApiRateLimiter(60, Duration.ofMinutes(1L), Duration.ofSeconds(1L));
    private final String entsoeSecurityToken;

    public EntsoeClient(String entsoeSecurityToken) {
        if (entsoeSecurityToken == null) {
            throw new IllegalArgumentException("entsoeSecurityToken must not be null");
        }
        this.entsoeSecurityToken = entsoeSecurityToken;
    }

    public EntsoeClient() {
        String property = System.getProperty("ENTSOE_SECURITY_TOKEN");
        if (property == null) {
            property = System.getenv("ENTSOE_SECURITY_TOKEN");
        }
        if (property == null) {
            throw new IllegalStateException("ENTSOE_SECURITY_TOKEN must not be null");
        }
        this.entsoeSecurityToken = property;
    }

    public TreeMap<EntsoeDate, BigDecimal> getTimeSeries(EntsoeDate entsoeDate, EntsoeResolution entsoeResolution, ZonedDateTime cutOffDate) {
        TreeMap<EntsoeDate, BigDecimal> timeSeries = this.getTimeSeries(entsoeDate, entsoeResolution);
        if (cutOffDate != null) {
            TreeSet<EntsoeDate> entsoeDates = new TreeSet<EntsoeDate>(timeSeries.keySet());
            for (EntsoeDate date : entsoeDates) {
                if (!date.utcDate().isBefore(cutOffDate.minusHours(1L))) continue;
                timeSeries.remove(date);
            }
        }
        return timeSeries;
    }

    private TreeMap<EntsoeDate, BigDecimal> getTimeSeriesInternal(EntsoeDate entsoeDate, EntsoeResolution entsoeResolution) {
        TreeMap<EntsoeDate, BigDecimal> res = new TreeMap<EntsoeDate, BigDecimal>();
        String spotpriceDataRaw = this.getSpotpriceDataRaw(entsoeDate);
        if (spotpriceDataRaw == null) {
            return res;
        }
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document xmlDocument = builder.parse(new ByteArrayInputStream(spotpriceDataRaw.getBytes(StandardCharsets.UTF_8)));
            XPath xPath = XPathFactory.newInstance().newXPath();
            String expression = "/Publication_MarketDocument/TimeSeries/Period/resolution";
            NodeList nodeList = (NodeList)xPath.compile(expression).evaluate(xmlDocument, XPathConstants.NODESET);
            int length = nodeList.getLength();
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (int i = 0; i < length; ++i) {
                Node resoultionNode = nodeList.item(i);
                String resolution = resoultionNode.getTextContent();
                if (!resolution.equals(entsoeResolution.name())) continue;
                nodes.add(resoultionNode.getParentNode());
            }
            for (Node node : nodes) {
                String start = null;
                NodeList childNodes = node.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    NodeList childNodes1;
                    Node item = childNodes.item(i);
                    String nodeName = item.getNodeName();
                    if (nodeName.equals("timeInterval")) {
                        childNodes1 = item.getChildNodes();
                        for (int j = 0; j < childNodes1.getLength(); ++j) {
                            Node item1 = childNodes1.item(j);
                            if (!item1.getNodeName().equals("start")) continue;
                            start = item1.getTextContent();
                            LOGGER.fine("Found start of time interval: " + start);
                        }
                        continue;
                    }
                    if (!nodeName.equals("Point") || start == null) continue;
                    childNodes1 = item.getChildNodes();
                    Integer position = null;
                    BigDecimal price = null;
                    for (int j = 0; j < childNodes1.getLength(); ++j) {
                        String textContent;
                        Node item1 = childNodes1.item(j);
                        if (item1.getNodeName().equals("position")) {
                            textContent = item1.getTextContent();
                            position = Integer.parseInt(textContent);
                            continue;
                        }
                        if (!item1.getNodeName().equals("price.amount")) continue;
                        textContent = item1.getTextContent();
                        price = new BigDecimal(textContent).divide(BigDecimal.TEN, RoundingMode.HALF_UP);
                    }
                    if (position == null || price == null) continue;
                    ZonedDateTime zonedDateTime = ZonedDateTime.parse(start);
                    EntsoeDate entsoeStartDate = new EntsoeDate(zonedDateTime);
                    EntsoeDate priceDate = EntsoeDate.fromENTSOEDate(entsoeStartDate, position - 1, entsoeResolution);
                    LOGGER.finer("price mapping " + String.valueOf(priceDate) + "=" + String.valueOf(price));
                    res.put(priceDate, price.setScale(2, RoundingMode.HALF_UP));
                }
            }
            return res;
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    public TreeMap<EntsoeDate, BigDecimal> getTimeSeries(EntsoeDate entsoeDate, EntsoeResolution entsoeResolution) {
        return this.getTimeSeriesInternal(entsoeDate, entsoeResolution);
    }

    public TreeMap<EntsoeDate, BigDecimal> getTimeSeriesEx(EntsoeDate entsoeDate, EntsoeResolution entsoeResolution) {
        ZonedDateTime tomorrow;
        EntsoeDate entsoeDate2;
        TreeMap<EntsoeDate, BigDecimal> timeSeries2;
        TreeMap<EntsoeDate, BigDecimal> timeSeriesInternal = this.getTimeSeriesInternal(entsoeDate, entsoeResolution);
        if (LocalDateTime.now().getHour() > 12 && !(timeSeries2 = this.getTimeSeries(entsoeDate2 = new EntsoeDate(tomorrow = LocalDate.now().atStartOfDay().atZone(ZoneId.systemDefault()).plusDays(1L)), EntsoeResolution.PT60M)).isEmpty()) {
            for (EntsoeDate ed : timeSeries2.keySet()) {
                if (timeSeriesInternal.containsKey(ed)) continue;
                timeSeriesInternal.put(ed, timeSeries2.get(ed));
            }
        }
        return timeSeriesInternal;
    }

    public String getSpotpriceDataRaw(EntsoeDate entsoeDateIn) {
        ZonedDateTime zonedDateTime = entsoeDateIn.utcDate().withMinute(0).withHour(0);
        EntsoeDate entsoeDate = new EntsoeDate(zonedDateTime);
        this.apiRateLimiter.acquire();
        String requestURL = this.getRequestURL(new EntsoeDate(entsoeDate.utcDate()));
        LOGGER.log(Level.FINE, "GET " + requestURL);
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(requestURL)).build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response != null) {
                return response.body();
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    public String getRequestURL(EntsoeDate entsoeDate) {
        LOGGER.fine("ENTSOE securityToken=" + this.entsoeSecurityToken);
        ZonedDateTime utcDate = entsoeDate.utcDate();
        ZonedDateTime startDate = utcDate.withHour(0).withMinute(0);
        ZonedDateTime endDate = utcDate.withHour(23).withMinute(0);
        EntsoeDate entsoeDateStart = new EntsoeDate(startDate);
        EntsoeDate entsoeDateEnd = new EntsoeDate(endDate);
        return "https://web-api.tp.entsoe.eu/api?securityToken=" + this.entsoeSecurityToken + "&documentType=A44&in_Domain=10Y1001A1001A82H&out_Domain=10Y1001A1001A82H&periodStart=" + String.valueOf(entsoeDateStart) + "&periodEnd=" + String.valueOf(entsoeDateEnd);
    }
}

