/*
 * Decompiled with CFR 0.152.
 */
package entsoe;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class ApiRateLimiter {
    private final AtomicReference<Instant> lastUsed = new AtomicReference<Instant>(Instant.now());
    private final AtomicLong counter = new AtomicLong(0L);
    private final int maxRequestsPerDuration;
    private final Duration duration;
    private final Duration minWaitTimeBetweenRequests;

    public ApiRateLimiter(int maxRequestsPerDuration, Duration duration, Duration minWaitTimeBetweenRequests) {
        this.maxRequestsPerDuration = maxRequestsPerDuration;
        this.duration = duration;
        this.minWaitTimeBetweenRequests = minWaitTimeBetweenRequests;
    }

    synchronized boolean acquire() {
        long newCounter = this.counter.incrementAndGet();
        try {
            Thread.sleep(this.minWaitTimeBetweenRequests.toMillis());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (this.lastUsed.get().isBefore(Instant.now().minus(this.duration)) && newCounter > (long)this.maxRequestsPerDuration) {
            this.counter.set(0L);
            this.lastUsed.set(Instant.now());
            System.out.println("reset");
            return false;
        }
        return newCounter <= (long)this.maxRequestsPerDuration;
    }

    public synchronized void acquireWait() {
        while (!this.acquire()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

