/*
 * Decompiled with CFR 0.152.
 */
package de.chiflux.utils;

public record GeoCoords2D(double latitude, double longitude) {
    private static final double EARTH_RADIUS = 6371000.0;

    public static double calculateDistance(GeoCoords2D source, GeoCoords2D target) {
        return GeoCoords2D.calculateDistance(source.latitude, source.longitude, target.latitude, target.longitude);
    }

    public static double calculateDistance(GeoCoords2D source, double targetLatitude, double targetLongitude) {
        return GeoCoords2D.calculateDistance(source.latitude, source.longitude, targetLatitude, targetLongitude);
    }

    public static double calculateDistance(double sourceLatitude, double sourceLongitude, double targetLatitude, double targetLongitude) {
        double lat1Rad = Math.toRadians(sourceLatitude);
        double lon1Rad = Math.toRadians(sourceLongitude);
        double lat2Rad = Math.toRadians(targetLatitude);
        double lon2Rad = Math.toRadians(targetLongitude);
        double deltaLat = lat2Rad - lat1Rad;
        double deltaLon = lon2Rad - lon1Rad;
        double a = Math.pow(Math.sin(deltaLat / 2.0), 2.0) + Math.cos(lat1Rad) * Math.cos(lat2Rad) * Math.pow(Math.sin(deltaLon / 2.0), 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return 6371000.0 * c;
    }
}

