package de.chiflux.utils;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Utils for the Java Collection classes.
 */
public class CollectionUtils {

    /**
     * Sorts a given map by its values.
     * By using {@code new ArrayList<>(sortedMapByValue.entrySet())},
     * one can get a list that is ordered exactly as the map's values.
     * @param unsortedMap an unsorted map
     * @return a LinkedHashMap sorted by value
     * @param <K> key
     * @param <V> value
     */
    public static <K, V extends Comparable<? super V>> LinkedHashMap<K, V> sortMapByValue(Map<K, V> unsortedMap) {
        List<Map.Entry<K, V>> fromUnsortedToSortedList = new ArrayList<>(unsortedMap.entrySet());
        fromUnsortedToSortedList.sort(Map.Entry.comparingByValue());
        LinkedHashMap<K, V> sortedMap = new LinkedHashMap<>();
        for (Map.Entry<K, V> entry : fromUnsortedToSortedList) {
            sortedMap.put(entry.getKey(), entry.getValue());
        }
        return sortedMap;
    }

}
