/*
 * Decompiled with CFR 0.152.
 */
package de.chiflux.utils;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApiRateLimiter {
    private static final Logger LOGGER = Logger.getLogger(ApiRateLimiter.class.getName());
    private final AtomicReference<Instant> lastUsed = new AtomicReference<Instant>(Instant.now());
    private final AtomicLong counter = new AtomicLong(0L);
    private volatile int maxRequestsPerDuration;
    private volatile Duration duration = Duration.ofSeconds(5L);
    private volatile Duration minWaitTimeBetweenRequests = Duration.ofSeconds(2L);

    public ApiRateLimiter(int maxRequestsPerDuration, Duration duration, Duration minWaitTimeBetweenRequests) {
        this.setParameters(maxRequestsPerDuration, duration, minWaitTimeBetweenRequests);
    }

    synchronized boolean acquire() {
        long newCounter = this.counter.incrementAndGet();
        try {
            Thread.sleep(this.minWaitTimeBetweenRequests.toMillis());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (this.lastUsed.get().isBefore(Instant.now().minus(this.duration)) && newCounter > (long)this.maxRequestsPerDuration) {
            this.counter.set(0L);
            this.lastUsed.set(Instant.now());
            return false;
        }
        return newCounter <= (long)this.maxRequestsPerDuration;
    }

    public synchronized void acquireWait() {
        while (!this.acquire()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public synchronized void slowdown(int percent) {
        Duration newDuration = this.duration.multipliedBy(100 + percent).dividedBy(100L);
        Duration newMinWaitTimeBetweenRequests = this.minWaitTimeBetweenRequests.multipliedBy(100 + percent).dividedBy(100L);
        this.setParameters(this.maxRequestsPerDuration, newDuration, newMinWaitTimeBetweenRequests);
    }

    public synchronized void setParameters(int maxRequestsPerDuration, Duration duration, Duration minWaitTimeBetweenRequests) {
        this.maxRequestsPerDuration = maxRequestsPerDuration;
        this.duration = duration;
        this.minWaitTimeBetweenRequests = minWaitTimeBetweenRequests;
        LOGGER.log(Level.INFO, "Api Rate Limiter Params: " + maxRequestsPerDuration + " requests per " + duration + ". Min Wait time between requests: " + minWaitTimeBetweenRequests);
    }
}

