/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.quartz.spring.queue;

import de.chandre.quartz.spring.queue.AbstractQueueService;
import de.chandre.quartz.spring.queue.JobCallable;
import de.chandre.quartz.spring.queue.JobExecutionResult;
import de.chandre.quartz.spring.queue.QueuedInstance;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CallbackQueueServiceImpl
extends AbstractQueueService<Future<JobExecutionResult>> {
    private static final Log LOG = LogFactory.getLog(CallbackQueueServiceImpl.class);
    private ExecutorService defaultExecutorService = Executors.newSingleThreadExecutor();
    private Map<String, ExecutorService> jobQueueMap = new ConcurrentHashMap<String, ExecutorService>();
    private Set<String> offeredInstances = Collections.newSetFromMap(new ConcurrentHashMap());
    private boolean multipleInstancesAllowed;

    public CallbackQueueServiceImpl() {
        this(false);
    }

    public CallbackQueueServiceImpl(boolean allowMultipleInstances) {
        this.multipleInstancesAllowed = allowMultipleInstances;
    }

    @PreDestroy
    public void destroy() {
        this.shutdown();
    }

    private void shutdown() {
        super.shutdownExecutor(this.defaultExecutorService, LOG);
        this.defaultExecutorService = null;
        ((Stream)this.jobQueueMap.values().stream().parallel()).forEach(executor -> this.shutdownExecutor((ExecutorService)executor, LOG));
        this.jobQueueMap.clear();
        this.offeredInstances.clear();
    }

    @Override
    public Future<JobExecutionResult> queueMe(QueuedInstance instance) {
        String instanceKey = instance.getKey();
        LOG.debug((Object)("try queuing job " + instanceKey + " with hash: " + instance.hashCode()));
        if (!this.multipleInstancesAllowed && this.offeredInstances.contains(instanceKey)) {
            return null;
        }
        this.offeredInstances.add(instanceKey);
        JobCallable callable = new JobCallable(instance, this.offeredInstances);
        Future<JobExecutionResult> callResult = null;
        if ("default".equals(instance.getGroup())) {
            callResult = this.defaultExecutorService.submit(callable);
        } else {
            ExecutorService executorService = this.jobQueueMap.get(instance.getGroup());
            if (null == executorService) {
                executorService = Executors.newSingleThreadExecutor();
                ExecutorService otherExecutorService = this.jobQueueMap.putIfAbsent(instance.getGroup(), executorService);
                if (null != otherExecutorService) {
                    executorService = otherExecutorService;
                }
            }
            callResult = executorService.submit(callable);
        }
        return callResult;
    }

    @Override
    protected Collection<String> getGroupKeys() {
        return this.jobQueueMap.keySet();
    }

    public void reset() {
        this.shutdown();
        this.defaultExecutorService = Executors.newSingleThreadExecutor();
    }
}

