/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.quartz.spring.queue;

import de.chandre.quartz.spring.queue.AbstractQueueService;
import de.chandre.quartz.spring.queue.QueuedInstance;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsyncQueueServiceImpl
extends AbstractQueueService<Boolean> {
    private static final Log LOG = LogFactory.getLog(AsyncQueueServiceImpl.class);
    private Map<String, Queue<QueuedInstance>> jobQueueMap = new ConcurrentHashMap<String, Queue<QueuedInstance>>();
    private ExecutorService executorService;
    private boolean multipleInstancesAllowed;

    public AsyncQueueServiceImpl() {
        this(false);
    }

    public AsyncQueueServiceImpl(boolean allowMultipleInstances) {
        this.multipleInstancesAllowed = allowMultipleInstances;
    }

    @PostConstruct
    public void init() {
        this.runQueue();
    }

    @PreDestroy
    public void destroy() {
        this.shutdown();
    }

    private void shutdown() {
        super.shutdownExecutor(this.executorService, LOG);
        this.executorService = null;
        this.jobQueueMap.clear();
    }

    @Override
    public Boolean queueMe(QueuedInstance instance) {
        Optional<QueuedInstance> queuedInstance;
        LOG.debug((Object)("try queuing job " + instance.getKey() + " with hash: " + instance.hashCode()));
        Queue<QueuedInstance> jobQueue = this.jobQueueMap.get(instance.getGroup());
        if (null == jobQueue) {
            jobQueue = new ConcurrentLinkedQueue<QueuedInstance>();
            Queue<QueuedInstance> otherJobQueue = this.jobQueueMap.putIfAbsent(instance.getGroup(), jobQueue);
            if (null != otherJobQueue) {
                jobQueue = otherJobQueue;
            }
        }
        if (!this.multipleInstancesAllowed && (queuedInstance = jobQueue.stream().filter(qi -> qi.getName().equals(instance.getName())).findFirst()).isPresent()) {
            return Boolean.FALSE;
        }
        return jobQueue.add(instance);
    }

    Map<String, Queue<QueuedInstance>> getQueueMap() {
        return this.jobQueueMap;
    }

    private void runQueue() {
        this.executorService = Executors.newSingleThreadExecutor();
        this.executorService.execute(new QueueTask(this));
    }

    @Override
    protected Collection<String> getGroupKeys() {
        return this.jobQueueMap.keySet();
    }

    public void reset() {
        this.shutdown();
        this.executorService = Executors.newSingleThreadExecutor();
    }

    private static class QueueTask
    implements Runnable {
        private AsyncQueueServiceImpl service;

        QueueTask(AsyncQueueServiceImpl serviceInstance) {
            this.service = serviceInstance;
        }

        @Override
        public void run() {
            while (true) {
                this.service.getQueueMap().values().parallelStream().forEach(jobQueue -> {
                    QueuedInstance queuedInstance = (QueuedInstance)jobQueue.poll();
                    if (null != queuedInstance) {
                        LOG.info((Object)("starting queued quartz instance " + queuedInstance.getName()));
                        try {
                            boolean result = queuedInstance.run();
                            if (!result) {
                                LOG.info((Object)("queued quartz instance " + queuedInstance.getName() + " ended with false"));
                            }
                        }
                        catch (Exception e) {
                            LOG.error((Object)("queued quartz instance thowed an exception: " + queuedInstance.getName()));
                            LOG.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                });
            }
        }
    }
}

