/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.quartz.spring;

import de.chandre.quartz.spring.AutowiringSpringBeanJobFactory;
import de.chandre.quartz.spring.QuartzPropertiesOverrideHook;
import de.chandre.quartz.spring.QuartzSchedulerFactoryOverrideHook;
import de.chandre.quartz.spring.QuartzSchedulerProperties;
import de.chandre.quartz.spring.listener.TriggerMetricsListener;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.impl.SchedulerRepository;
import org.quartz.spi.JobFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={QuartzSchedulerProperties.class})
@ConditionalOnClass(value={Scheduler.class})
public class QuartzSchedulerAutoConfiguration {
    private static final Log LOGGER = LogFactory.getLog(QuartzSchedulerAutoConfiguration.class);
    public static final String QUARTZ_PROPERTIES_BEAN_NAME = "quartzProperties";
    public static final String QUARTZ_SCHEDULER_FACTORY_BEAN_NAME = "autoSchedulerFactory";
    public static final String QUARTZ_JOB_FACTORY_BEAN_NAME = "autoJobFactory";
    public static final String QUARTZ_SCHEDULER_METRICS_LISTENER_BEAN_NAME = "quartzMetricsListener";

    @Configuration
    @ConditionalOnProperty(prefix="quartz.metrics", name={"enabled"}, havingValue="true", matchIfMissing=false)
    @ConditionalOnMissingBean(name={"quartzMetricsListener"})
    @AutoConfigureBefore(name={"autoSchedulerFactory"})
    protected static class SchedulerMetricsListenerConfiguration {
        protected SchedulerMetricsListenerConfiguration() {
        }

        @Bean(name={"quartzMetricsListener"})
        @ConditionalOnMissingBean
        public TriggerMetricsListener schedulerMetricsListener(@Autowired(required=false) QuartzSchedulerProperties properties) {
            if (null == properties) {
                LOGGER.warn((Object)"no QuartzSchedulerProperties found, consider to set quartz.enabled=true in properties");
                return null;
            }
            TriggerMetricsListener listener = new TriggerMetricsListener(properties.getMetrics(), properties.getMetrics().getListenerName());
            return listener;
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="quartz", name={"enabled"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(name={"autoSchedulerFactory"})
    protected static class SchedulerFactoryConfiguration {
        protected SchedulerFactoryConfiguration() {
        }

        private static Collection<Trigger> getTriggers(ApplicationContext applicationContext) {
            Map triggers = applicationContext.getBeansOfType(Trigger.class);
            if (null != triggers && !triggers.isEmpty()) {
                return triggers.values();
            }
            return null;
        }

        private static PlatformTransactionManager getTransactionManager(ApplicationContext applicationContext, String txManagerBeanName) {
            Map txManagers = applicationContext.getBeansOfType(PlatformTransactionManager.class);
            if (null != txManagers && txManagers.size() > 0) {
                if (txManagers.size() == 1) {
                    LOGGER.debug((Object)("only one txManager found, returning: " + (String)txManagers.keySet().iterator().next()));
                    return (PlatformTransactionManager)txManagers.values().iterator().next();
                }
                if (!StringUtils.isEmpty((Object)txManagerBeanName)) {
                    LOGGER.debug((Object)("more than one txManager found, try using: " + txManagerBeanName));
                    PlatformTransactionManager txManager = (PlatformTransactionManager)txManagers.get(txManagerBeanName);
                    if (null == txManager) {
                        LOGGER.warn((Object)("QuartzSchedulerAutoConfiguration is configured to use " + txManagerBeanName + " as PlatformTransactionManager, but no bean for this name has been found in context!"));
                    }
                    return txManager;
                }
                LOGGER.warn((Object)"QuartzSchedulerAutoConfiguration is configured to use PlatformTransactionManager, but more than one has been found in context! Consider using quartz.persistence.platform-tx-manager-bean-name in pallication configuration.");
            } else {
                LOGGER.warn((Object)"QuartzSchedulerAutoConfiguration is configured to use PlatformTransactionManager, but no bean of this type has been found in context!");
            }
            return null;
        }

        private static DataSource getDataSource(ApplicationContext applicationContext, QuartzSchedulerProperties.Persistence persistenceSettings) {
            int dsSize;
            DataSource dataSource = null;
            Map datasources = applicationContext.getBeansOfType(DataSource.class);
            int n = dsSize = null != datasources ? datasources.size() : 0;
            if (null != datasources && null != persistenceSettings.getDataSourceName()) {
                dataSource = (DataSource)datasources.get(persistenceSettings.getDataSourceName());
            } else if (null != datasources && dsSize == 1 && null == persistenceSettings.getDataSourceName()) {
                dataSource = (DataSource)datasources.values().iterator().next();
            }
            if (dataSource == null) {
                throw new BeanInitializationException("A datasource is required when starting Quartz-Scheduler in persisted mode. No DS found in map with size: " + dsSize + ", and configured DSName: " + persistenceSettings.getDataSourceName());
            }
            return dataSource;
        }

        private static QuartzSchedulerFactoryOverrideHook getQuartzSchedulerFactoryOverrideHook(ApplicationContext applicationContext) {
            try {
                return (QuartzSchedulerFactoryOverrideHook)applicationContext.getBean(QuartzSchedulerFactoryOverrideHook.class);
            }
            catch (Exception e) {
                LOGGER.info((Object)"no QuartzSchedulerFactoryOverrideHook configured");
                LOGGER.trace((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }

        @Bean(name={"autoJobFactory"})
        @ConditionalOnMissingBean(name={"autoJobFactory"})
        public JobFactory autoJobFactory(ApplicationContext applicationContext, @Autowired(required=false) QuartzSchedulerProperties properties) {
            if (null == properties) {
                LOGGER.warn((Object)"no QuartzSchedulerProperties found, consider to set quartz.enabled=true in properties");
                return null;
            }
            AutowiringSpringBeanJobFactory jobFactory = new AutowiringSpringBeanJobFactory();
            jobFactory.setApplicationContext(applicationContext);
            return jobFactory;
        }

        @Bean(name={"quartzProperties"})
        @ConditionalOnMissingBean(name={"quartzProperties"})
        public Properties quartzProperties(ApplicationContext applicationContext, @Autowired(required=false) QuartzSchedulerProperties properties) throws IOException {
            if (null == properties) {
                LOGGER.warn((Object)"no QuartzSchedulerProperties found, consider to set quartz.enabled=true in properties");
                return null;
            }
            Properties quartzProperties = null;
            if (properties.isOverrideConfigLocationProperties()) {
                quartzProperties = SchedulerFactoryConfiguration.loadConfigLocationProperties(applicationContext, properties);
                quartzProperties.putAll(properties.getProperties());
            } else {
                quartzProperties = null != properties.getProperties() && !properties.getProperties().isEmpty() ? SchedulerFactoryConfiguration.getConfiguredProperties(properties) : SchedulerFactoryConfiguration.loadConfigLocationProperties(applicationContext, properties);
            }
            QuartzPropertiesOverrideHook hook = SchedulerFactoryConfiguration.getQuartzPropOverrideHook(applicationContext);
            if (null != hook) {
                quartzProperties = hook.override(quartzProperties);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Quartz-Properties");
                quartzProperties.entrySet().forEach(entry -> LOGGER.debug((Object)("    " + entry.getKey() + " = " + entry.getValue())));
            }
            return quartzProperties;
        }

        private static Properties getConfiguredProperties(QuartzSchedulerProperties properties) {
            Properties quartzProperties = new Properties();
            quartzProperties.putAll(properties.getProperties());
            return quartzProperties;
        }

        private static Properties loadConfigLocationProperties(ApplicationContext applicationContext, QuartzSchedulerProperties properties) throws IOException {
            String location = properties.getPropertiesConfigLocation();
            if (null == location || location.trim().length() == 0) {
                location = "classpath:/org/quartz/quartz.properties";
                LOGGER.debug((Object)("using default 'quartz.properties' from classpath: " + location));
            } else {
                LOGGER.debug((Object)("using 'quartz.properties' from location: " + location));
            }
            PropertiesFactoryBean propertiesFactoryBean = new PropertiesFactoryBean();
            propertiesFactoryBean.setLocation(applicationContext.getResource(location));
            propertiesFactoryBean.afterPropertiesSet();
            return propertiesFactoryBean.getObject();
        }

        private static QuartzPropertiesOverrideHook getQuartzPropOverrideHook(ApplicationContext applicationContext) {
            try {
                return (QuartzPropertiesOverrideHook)applicationContext.getBean(QuartzPropertiesOverrideHook.class);
            }
            catch (Exception e) {
                LOGGER.info((Object)"no QuartzPropertiesOverrideHook configured");
                LOGGER.trace((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }

        @Bean(name={"autoSchedulerFactory"})
        @ConditionalOnMissingBean
        public SchedulerFactoryBean autoSchedulerFactory(ApplicationContext applicationContext, JobFactory jobFactory, @Autowired(required=false) QuartzSchedulerProperties properties, @Qualifier(value="quartzProperties") Properties quartzProperties, @Autowired(required=false) List<TriggerListener> triggerListeners, @Autowired(required=false) List<JobListener> jobListeners, @Autowired(required=false) List<SchedulerListener> schedulerListeners) {
            Collection<Trigger> triggers;
            if (null == properties) {
                LOGGER.warn((Object)"no QuartzSchedulerProperties found, consider to set quartz.enabled=true in properties");
                return null;
            }
            LOGGER.debug((Object)"creating SchedulerFactory");
            QuartzSchedulerProperties.SchedulerFactory factorySettings = properties.getSchedulerFactory();
            SchedulerRepository schedulerRepo = SchedulerRepository.getInstance();
            if (schedulerRepo.remove(QuartzSchedulerAutoConfiguration.QUARTZ_SCHEDULER_FACTORY_BEAN_NAME)) {
                LOGGER.debug((Object)"removed scheduler from SchedulerRepository with name: autoSchedulerFactory");
            }
            if (null != factorySettings.getSchedulerName() && schedulerRepo.remove(factorySettings.getSchedulerName())) {
                LOGGER.debug((Object)("removed scheduler from SchedulerRepository with name: " + factorySettings.getSchedulerName()));
            }
            SchedulerFactoryBean factory = (SchedulerFactoryBean)BeanUtils.instantiateClass(SchedulerFactoryBean.class);
            factory.setApplicationContext(applicationContext);
            factory.setJobFactory(jobFactory);
            QuartzSchedulerProperties.Persistence persistenceSettings = properties.getPersistence();
            if (persistenceSettings.isPersisted()) {
                PlatformTransactionManager txManager;
                factory.setDataSource(SchedulerFactoryConfiguration.getDataSource(applicationContext, persistenceSettings));
                if (persistenceSettings.isUsePlatformTxManager() && null != (txManager = SchedulerFactoryConfiguration.getTransactionManager(applicationContext, persistenceSettings.getPlatformTxManagerBeanName()))) {
                    factory.setTransactionManager(txManager);
                }
            }
            if (!StringUtils.isEmpty((Object)factorySettings.getSchedulerName())) {
                factory.setSchedulerName(factorySettings.getSchedulerName());
            } else {
                LOGGER.debug((Object)"no SchedulerName configured, using bean name: autoSchedulerFactory");
            }
            factory.setPhase(factorySettings.getPhase());
            factory.setStartupDelay(factorySettings.getStartupDelay());
            factory.setAutoStartup(factorySettings.isAutoStartup());
            factory.setWaitForJobsToCompleteOnShutdown(factorySettings.isWaitForJobsToCompleteOnShutdown());
            factory.setOverwriteExistingJobs(factorySettings.isOverwriteExistingJobs());
            factory.setExposeSchedulerInRepository(factorySettings.isExposeSchedulerInRepository());
            factory.setQuartzProperties(quartzProperties);
            if (!CollectionUtils.isEmpty(jobListeners)) {
                LOGGER.info((Object)("configuring " + jobListeners.size() + " job listeners"));
                factory.setGlobalJobListeners(jobListeners.toArray(new JobListener[0]));
            }
            if (!CollectionUtils.isEmpty(triggerListeners)) {
                LOGGER.info((Object)("configuring " + triggerListeners.size() + " trigger listeners"));
                factory.setGlobalTriggerListeners(triggerListeners.toArray(new TriggerListener[0]));
            }
            if (!CollectionUtils.isEmpty(schedulerListeners)) {
                LOGGER.info((Object)("configuring " + schedulerListeners.size() + " scheduler listeners"));
                factory.setSchedulerListeners(schedulerListeners.toArray(new SchedulerListener[0]));
            }
            if (null != (triggers = SchedulerFactoryConfiguration.getTriggers(applicationContext)) && !triggers.isEmpty()) {
                factory.setTriggers(triggers.toArray(new Trigger[triggers.size()]));
                LOGGER.info((Object)("staring scheduler factory with " + triggers.size() + " job triggers"));
            } else {
                LOGGER.info((Object)"staring scheduler factory with 0 job triggers");
            }
            QuartzSchedulerFactoryOverrideHook hook = SchedulerFactoryConfiguration.getQuartzSchedulerFactoryOverrideHook(applicationContext);
            if (null != hook) {
                factory = hook.override(factory, properties, quartzProperties);
            }
            return factory;
        }
    }
}

