/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.quartz.spring;

import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.SimpleTrigger;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.scheduling.quartz.SimpleTriggerFactoryBean;

public class QuartzUtils {
    private QuartzUtils() {
    }

    public static QuartzJobBuilder jobBuilder() {
        return new QuartzJobBuilder();
    }

    public static JobDetailFactoryBean createJobDetail(Class<?> jobClass, String jobName, String jobGroup, String jobDdescription, Map<String, ?> jobData) {
        return QuartzUtils.jobBuilder().jobClass(jobClass).name(jobName).group(jobGroup).description(jobDdescription).putJobData(jobData).durability(true).getJobDetailFactoryBean();
    }

    public static JobDetailFactoryBean createJobDetail(Class<?> jobClass, String jobName, String jobGroup, String jobDdescription, Map<String, ?> jobData, boolean durable, boolean requestsRecovery) {
        return QuartzUtils.jobBuilder().jobClass(jobClass).name(jobName).group(jobGroup).description(jobDdescription).putJobData(jobData).durability(durable).requestRecovery(requestsRecovery).getJobDetailFactoryBean();
    }

    public static QuartzSimpleTriggerBuilder simpleTriggerBuilder() {
        return new QuartzSimpleTriggerBuilder();
    }

    public static SimpleTriggerFactoryBean createSimpleTrigger(JobDetail jobDetail, String triggerName, String triggerGroup, String triggerDescription, long startDelay, long repeatInterval, Map<String, ?> jobData) {
        return QuartzUtils.simpleTriggerBuilder().jobDetail(jobDetail).name(triggerName).group(triggerGroup).description(triggerDescription).startDelay(startDelay).repeatInterval(repeatInterval).repeatCount(-1).misfireInstruction(4).putJobData(jobData).getTriggerFactoryBean();
    }

    public static SimpleTriggerFactoryBean createSimpleTrigger(JobDetail jobDetail, String triggerName, String triggerGroup, String triggerDescription, long startDelay, long repeatInterval, int repeatCount, int misfireInstruction, Map<String, ?> jobData, int priority) {
        return QuartzUtils.simpleTriggerBuilder().jobDetail(jobDetail).name(triggerName).group(triggerGroup).description(triggerDescription).startDelay(startDelay).repeatInterval(repeatInterval).repeatCount(repeatCount).misfireInstruction(misfireInstruction).putJobData(jobData).priority(priority).getTriggerFactoryBean();
    }

    public static QuartzCronTriggerBuilder cronTriggerBuilder() {
        return new QuartzCronTriggerBuilder();
    }

    public static CronTriggerFactoryBean createCronTrigger(JobDetail jobDetail, String triggerName, String triggerGroup, String triggerDescription, String cronExpression, long startDelay, Map<String, ?> jobData) {
        return QuartzUtils.cronTriggerBuilder().jobDetail(jobDetail).name(triggerName).group(triggerGroup).description(triggerDescription).cronExpression(cronExpression).startDelay(startDelay).misfireInstruction(2).putJobData(jobData).getTriggerFactoryBean();
    }

    public static CronTriggerFactoryBean createCronTrigger(JobDetail jobDetail, String triggerName, String triggerGroup, String triggerDescription, String cronExpression, int misfireInstruction, Map<String, ?> jobData, long startDelay, Date startTime, String timeZone, int priority) {
        return QuartzUtils.cronTriggerBuilder().jobDetail(jobDetail).name(triggerName).group(triggerGroup).description(triggerDescription).cronExpression(cronExpression).startDelay(startDelay).misfireInstruction(misfireInstruction).putJobData(jobData).timeZone(timeZone).startTime(startTime).priority(priority).getTriggerFactoryBean();
    }

    public static class QuartzCronTriggerBuilder {
        private final CronTriggerFactoryBean triggerFactoryBean = new CronTriggerFactoryBean();

        public QuartzCronTriggerBuilder jobDetail(JobDetail jobDetail) {
            this.triggerFactoryBean.setJobDetail(jobDetail);
            return this;
        }

        public QuartzCronTriggerBuilder beanName(String beanName) {
            this.triggerFactoryBean.setBeanName(beanName);
            return this;
        }

        public QuartzCronTriggerBuilder name(String name) {
            this.triggerFactoryBean.setName(name);
            return this;
        }

        public QuartzCronTriggerBuilder group(String group) {
            this.triggerFactoryBean.setGroup(group);
            return this;
        }

        public QuartzCronTriggerBuilder description(String description) {
            this.triggerFactoryBean.setDescription(description);
            return this;
        }

        public QuartzCronTriggerBuilder cronExpression(String cronExpression) {
            this.triggerFactoryBean.setCronExpression(cronExpression);
            return this;
        }

        public QuartzCronTriggerBuilder startDelay(long startDelay) {
            this.triggerFactoryBean.setStartDelay(startDelay);
            return this;
        }

        public QuartzCronTriggerBuilder startTime(Date startTime) {
            this.triggerFactoryBean.setStartTime(startTime);
            return this;
        }

        public QuartzCronTriggerBuilder misfireInstruction(int misfireInstruction) {
            this.triggerFactoryBean.setMisfireInstruction(misfireInstruction);
            return this;
        }

        public QuartzCronTriggerBuilder misfireInstructionName(String misfireInstructionName) {
            this.triggerFactoryBean.setMisfireInstructionName(misfireInstructionName);
            return this;
        }

        public QuartzCronTriggerBuilder priority(int priority) {
            this.triggerFactoryBean.setPriority(priority);
            return this;
        }

        public QuartzCronTriggerBuilder timeZone(String timeZone) {
            return this.timeZone(TimeZone.getTimeZone(timeZone));
        }

        public QuartzCronTriggerBuilder timeZone(TimeZone timeZone) {
            this.triggerFactoryBean.setTimeZone(timeZone);
            return this;
        }

        public QuartzCronTriggerBuilder putJobData(Map<String, ?> jobData) {
            if (null != jobData) {
                this.triggerFactoryBean.getJobDataMap().putAll(jobData);
            }
            return this;
        }

        public QuartzCronTriggerBuilder addJobData(String key, Object value) {
            this.triggerFactoryBean.getJobDataMap().put(key, value);
            return this;
        }

        public QuartzCronTriggerBuilder calendarName(String calendarName) {
            this.triggerFactoryBean.setCalendarName(calendarName);
            return this;
        }

        public CronTriggerFactoryBean getTriggerFactoryBean() {
            return this.triggerFactoryBean;
        }

        public CronTrigger build() throws ParseException {
            this.triggerFactoryBean.afterPropertiesSet();
            return this.triggerFactoryBean.getObject();
        }
    }

    public static class QuartzSimpleTriggerBuilder {
        private final SimpleTriggerFactoryBean triggerFactoryBean = new SimpleTriggerFactoryBean();

        public QuartzSimpleTriggerBuilder jobDetail(JobDetail jobDetail) {
            this.triggerFactoryBean.setJobDetail(jobDetail);
            return this;
        }

        public QuartzSimpleTriggerBuilder beanName(String beanName) {
            this.triggerFactoryBean.setBeanName(beanName);
            return this;
        }

        public QuartzSimpleTriggerBuilder name(String name) {
            this.triggerFactoryBean.setName(name);
            return this;
        }

        public QuartzSimpleTriggerBuilder group(String group) {
            this.triggerFactoryBean.setGroup(group);
            return this;
        }

        public QuartzSimpleTriggerBuilder description(String description) {
            this.triggerFactoryBean.setDescription(description);
            return this;
        }

        public QuartzSimpleTriggerBuilder startDelay(long startDelay) {
            this.triggerFactoryBean.setStartDelay(startDelay);
            return this;
        }

        public QuartzSimpleTriggerBuilder startTime(Date startTime) {
            this.triggerFactoryBean.setStartTime(startTime);
            return this;
        }

        public QuartzSimpleTriggerBuilder misfireInstruction(int misfireInstruction) {
            this.triggerFactoryBean.setMisfireInstruction(misfireInstruction);
            return this;
        }

        public QuartzSimpleTriggerBuilder misfireInstructionName(String misfireInstructionName) {
            this.triggerFactoryBean.setMisfireInstructionName(misfireInstructionName);
            return this;
        }

        public QuartzSimpleTriggerBuilder priority(int priority) {
            this.triggerFactoryBean.setPriority(priority);
            return this;
        }

        public QuartzSimpleTriggerBuilder repeatCount(int repeatCount) {
            this.triggerFactoryBean.setRepeatCount(repeatCount);
            return this;
        }

        public QuartzSimpleTriggerBuilder repeatInterval(long repeatInterval) {
            this.triggerFactoryBean.setRepeatInterval(repeatInterval);
            return this;
        }

        public QuartzSimpleTriggerBuilder putJobData(Map<String, ?> jobData) {
            if (null != jobData) {
                this.triggerFactoryBean.getJobDataMap().putAll(jobData);
            }
            return this;
        }

        public QuartzSimpleTriggerBuilder addJobData(String key, Object value) {
            this.triggerFactoryBean.getJobDataMap().put(key, value);
            return this;
        }

        public SimpleTriggerFactoryBean getTriggerFactoryBean() {
            return this.triggerFactoryBean;
        }

        public SimpleTrigger build() throws ParseException {
            this.triggerFactoryBean.afterPropertiesSet();
            return this.triggerFactoryBean.getObject();
        }
    }

    public static class QuartzJobBuilder {
        private final JobDetailFactoryBean jobDetailFactoryBean = new JobDetailFactoryBean();

        public QuartzJobBuilder jobClass(Class<?> clazz) {
            this.jobDetailFactoryBean.setJobClass(clazz);
            return this;
        }

        public QuartzJobBuilder beanName(String beanName) {
            this.jobDetailFactoryBean.setBeanName(beanName);
            return this;
        }

        public QuartzJobBuilder name(String name) {
            this.jobDetailFactoryBean.setName(name);
            return this;
        }

        public QuartzJobBuilder group(String group) {
            this.jobDetailFactoryBean.setGroup(group);
            return this;
        }

        public QuartzJobBuilder description(String description) {
            this.jobDetailFactoryBean.setDescription(description);
            return this;
        }

        public QuartzJobBuilder durability(boolean durability) {
            this.jobDetailFactoryBean.setDurability(durability);
            return this;
        }

        public QuartzJobBuilder requestRecovery(boolean requestRecovery) {
            this.jobDetailFactoryBean.setRequestsRecovery(requestRecovery);
            return this;
        }

        public QuartzJobBuilder putJobData(Map<String, ?> jobData) {
            if (null != jobData) {
                this.jobDetailFactoryBean.getJobDataMap().putAll(jobData);
            }
            return this;
        }

        public QuartzJobBuilder addJobData(String key, Object value) {
            this.jobDetailFactoryBean.getJobDataMap().put(key, value);
            return this;
        }

        public JobDetailFactoryBean getJobDetailFactoryBean() {
            return this.jobDetailFactoryBean;
        }

        public JobDetail build() {
            this.jobDetailFactoryBean.afterPropertiesSet();
            return this.jobDetailFactoryBean.getObject();
        }
    }
}

