/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.quartz;

import de.chandre.admintool.quartz.AdminToolQuartzConfig;
import de.chandre.admintool.quartz.AdminToolQuartzService;
import de.chandre.admintool.quartz.JobTriggerTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CalendarIntervalScheduleBuilder;
import org.quartz.CalendarIntervalTrigger;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.DailyTimeIntervalScheduleBuilder;
import org.quartz.DailyTimeIntervalTrigger;
import org.quartz.DateBuilder;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerMetaData;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.StatefulJob;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.utils.Key;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="adminToolQuartzService")
public class AdminToolQuartzServiceImpl
implements AdminToolQuartzService {
    private static final Log LOGGER = LogFactory.getLog(AdminToolQuartzServiceImpl.class);
    @Autowired
    private Scheduler scheduler;
    @Autowired
    private SchedulerFactoryBean schedulerFactory;
    @Autowired
    private AdminToolQuartzConfig config;
    private String prevGroup;
    private String prevJob;

    @Override
    public void startScheduler() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"starting scheduler factory");
        }
        this.schedulerFactory.start();
    }

    @Override
    public void stopScheduler() {
        if (!this.config.isStopSchedulerAllowed()) {
            LOGGER.warn((Object)"not allowed to stop the scheduler");
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"stopping scheduler factory");
        }
        this.schedulerFactory.stop();
    }

    @Override
    public boolean isSchedulerRunning() {
        return this.schedulerFactory.isRunning();
    }

    @Override
    public SchedulerMetaData getMetaData() throws SchedulerException {
        return this.scheduler.getMetaData();
    }

    @Override
    public List<String> getJobGroups() throws SchedulerException {
        List groups = this.scheduler.getJobGroupNames();
        Collections.sort(groups);
        return groups;
    }

    @Override
    public boolean isPrevGoupNotEq(String actualGroup) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)String.format("check group prev: %s, act: %s", this.prevGroup, actualGroup));
        }
        return StringUtils.isEmpty((Object)this.prevGroup) || !actualGroup.equals(this.prevGroup);
    }

    @Override
    public boolean setPrevGroup(String prevGroup) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)String.format("set previous group : %s", prevGroup));
        }
        this.prevGroup = prevGroup;
        return true;
    }

    @Override
    public boolean isPrevJobNotEq(String actualJob) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)String.format("check job prev: %s, act: %s", this.prevJob, actualJob));
        }
        return StringUtils.isEmpty((Object)this.prevJob) || !actualJob.equals(this.prevJob);
    }

    @Override
    public boolean setPrevJob(String prevJob) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)String.format("set previous job : %s", prevJob));
        }
        this.prevJob = prevJob;
        return true;
    }

    @Override
    public Set<JobKey> getJobKeys(String group) throws SchedulerException {
        return this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)group));
    }

    @Override
    public String getJobDescription(JobKey jobKey) throws SchedulerException {
        return this.scheduler.getJobDetail(jobKey).getDescription();
    }

    @Override
    public List<? extends Trigger> getTriggers(JobKey jobKey) throws SchedulerException {
        ArrayList triggers = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)this.scheduler.getTriggersOfJob(jobKey))) {
            triggers.addAll(this.scheduler.getTriggersOfJob(jobKey));
            Collections.sort(triggers, new Comparator<Trigger>(){

                @Override
                public int compare(Trigger o1, Trigger o2) {
                    return o1.getKey().compareTo((Key)o2.getKey());
                }
            });
        }
        return triggers;
    }

    @Override
    public int getCurrentlyExecutingAmount(JobKey jobKey) throws SchedulerException {
        List executingJobs = this.scheduler.getCurrentlyExecutingJobs();
        JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
        int numInstances = 0;
        for (JobExecutionContext jobExecutionContext : executingJobs) {
            JobDetail execJobDetail = jobExecutionContext.getJobDetail();
            if (!execJobDetail.getKey().equals((Object)jobDetail.getKey())) continue;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)String.format("found running job for jobkey: (%s, %s)", jobKey.getGroup(), jobKey.getName()));
            }
            ++numInstances;
        }
        return numInstances;
    }

    @Override
    public boolean isPaused(JobKey jobKey) throws SchedulerException {
        List triggers = this.scheduler.getTriggersOfJob(jobKey);
        boolean result = true;
        if (null != triggers && triggers.size() > 0) {
            for (Trigger trigger : triggers) {
                result = result && this.scheduler.getTriggerState(trigger.getKey()) == Trigger.TriggerState.PAUSED;
            }
            return result;
        }
        return false;
    }

    @Override
    public boolean isOnePaused(JobKey jobKey) throws SchedulerException {
        List triggers = this.scheduler.getTriggersOfJob(jobKey);
        boolean result = false;
        if (null != triggers && triggers.size() > 0) {
            for (Trigger trigger : triggers) {
                result = result || this.scheduler.getTriggerState(trigger.getKey()) == Trigger.TriggerState.PAUSED;
            }
            return result;
        }
        return false;
    }

    @Override
    public boolean isPaused(Trigger trigger) throws SchedulerException {
        return this.scheduler.getTriggerState(trigger.getKey()) == Trigger.TriggerState.PAUSED;
    }

    @Override
    public String getTriggerStateCssClass(JobKey jobKey, Trigger trigger) throws SchedulerException {
        if (this.isPaused(trigger)) {
            return "btn-warning";
        }
        if (this.isCurrentlyRunning(jobKey, trigger)) {
            return "btn-success";
        }
        return "btn-info";
    }

    @Override
    public String getTriggerState(JobKey jobKey, Trigger trigger) throws SchedulerException {
        if (this.isPaused(trigger)) {
            return "paused";
        }
        if (this.isCurrentlyRunning(jobKey, trigger)) {
            return "running";
        }
        return "pending";
    }

    @Override
    public boolean isCurrentlyRunning(JobKey jobKey, Trigger trigger) throws SchedulerException {
        List executingJobs = this.scheduler.getCurrentlyExecutingJobs();
        JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
        Trigger triggerFound = this.findTrigger(jobKey.getGroup(), jobKey.getName(), trigger.getKey().getGroup(), trigger.getKey().getName());
        for (JobExecutionContext jobExecutionContext : executingJobs) {
            JobDetail execJobDetail = jobExecutionContext.getJobDetail();
            if (!execJobDetail.getKey().equals((Object)jobDetail.getKey()) || !jobExecutionContext.getTrigger().getKey().equals((Object)triggerFound.getKey())) continue;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)String.format("found running trigger for jobkey: (%s, %s, %s)", jobKey.getGroup(), jobKey.getName(), trigger.getKey().getName()));
            }
            return true;
        }
        return false;
    }

    @Override
    public String getCronExpression(Trigger trigger, String defaultValue) {
        return this.isCronTrigger(trigger) ? ((CronTrigger)trigger).getCronExpression() : defaultValue;
    }

    @Override
    public boolean isCronTrigger(Trigger trigger) {
        return trigger instanceof CronTrigger;
    }

    @Override
    public boolean isInteruptable(JobKey jobKey) throws SchedulerException {
        return InterruptableJob.class.isAssignableFrom(this.scheduler.getJobDetail(jobKey).getJobClass());
    }

    @Override
    public boolean isStateful(JobKey jobKey) throws SchedulerException {
        Class jobClazz = this.scheduler.getJobDetail(jobKey).getJobClass();
        DisallowConcurrentExecution annotation1 = jobClazz.getAnnotation(DisallowConcurrentExecution.class);
        PersistJobDataAfterExecution annotation2 = jobClazz.getAnnotation(PersistJobDataAfterExecution.class);
        return StatefulJob.class.isAssignableFrom(jobClazz) || null != annotation1 || null != annotation2;
    }

    @Override
    public void interruptJob(String jobGroup, String jobName) throws SchedulerException {
        if (!this.config.isInterruptJobAllowed()) {
            LOGGER.warn((Object)"not allowed to interrupt any job");
            return;
        }
        JobKey jobKey = new JobKey(jobName, jobGroup);
        if (this.isInteruptable(jobKey)) {
            List executingJobs = this.scheduler.getCurrentlyExecutingJobs();
            JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
            for (JobExecutionContext jobExecutionContext : executingJobs) {
                JobDetail execJobDetail = jobExecutionContext.getJobDetail();
                if (!execJobDetail.getKey().equals((Object)jobDetail.getKey())) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)String.format("interrupting job (%s, %s)", jobDetail.getKey().getGroup(), jobDetail.getKey().getName()));
                }
                ((InterruptableJob)jobExecutionContext.getJobInstance()).interrupt();
            }
        }
    }

    @Override
    public void interruptTrigger(String jobGroup, String jobName, String triggerGroup, String triggerName) throws SchedulerException {
        if (!this.config.isInterruptTriggerAllowed()) {
            LOGGER.warn((Object)"not allowed to interrupt any trigger");
            return;
        }
        JobKey jobKey = new JobKey(jobName, jobGroup);
        if (this.isInteruptable(jobKey)) {
            List executingJobs = this.scheduler.getCurrentlyExecutingJobs();
            JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
            Trigger triggerFound = this.findTrigger(jobGroup, jobName, triggerGroup, triggerName);
            for (JobExecutionContext jobExecutionContext : executingJobs) {
                if (!jobExecutionContext.getJobDetail().getKey().equals((Object)jobDetail.getKey()) || !jobExecutionContext.getTrigger().getKey().equals((Object)triggerFound.getKey())) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)String.format("interrupting jobTrigger (%s, %s, %s)", jobDetail.getKey().getGroup(), jobDetail.getKey().getName(), triggerFound.getKey().getName()));
                }
                ((InterruptableJob)jobExecutionContext.getJobInstance()).interrupt();
            }
        }
    }

    @Override
    public void changeTriggerState(String groupName, String jobName, String triggerGroup, String triggerName) throws SchedulerException {
        if (!this.config.isChangetTriggerStateAllowed()) {
            LOGGER.warn((Object)"not allowed to change any trigger state");
            return;
        }
        Trigger triggerFound = this.findTrigger(groupName, jobName, triggerGroup, triggerName);
        if (null != triggerFound) {
            this.changeTriggerState(triggerFound);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("pausing trigger for group: %s, job: %s, trigger: %s ", groupName, jobName, triggerName));
            }
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("pausing all triggers for group: %s, job: %s", groupName, jobName));
            }
            List triggers = this.scheduler.getTriggersOfJob(new JobKey(jobName, groupName));
            for (Trigger trigger : triggers) {
                this.changeTriggerState(trigger);
            }
        }
    }

    private Trigger findTrigger(String jobGroup, String jobName, String triggerGroup, String triggerName) throws SchedulerException {
        Optional<Trigger> tr;
        List triggers = this.scheduler.getTriggersOfJob(new JobKey(jobName, jobGroup));
        if (!CollectionUtils.isEmpty((Collection)triggers) && (tr = triggers.stream().filter(trigger -> trigger.getKey().getGroup().equals(triggerGroup) && trigger.getKey().getName().equals(triggerName)).findFirst()).isPresent()) {
            return tr.get();
        }
        return null;
    }

    private void changeTriggerState(Trigger trigger) throws SchedulerException {
        if (this.scheduler.getTriggerState(trigger.getKey()) == Trigger.TriggerState.PAUSED) {
            this.scheduler.resumeTrigger(trigger.getKey());
        } else {
            this.scheduler.pauseTrigger(trigger.getKey());
        }
    }

    @Override
    public void triggerJob(String groupName, String jobName) throws SchedulerException {
        if (!this.config.isExecuteJobAllowed()) {
            LOGGER.warn((Object)"not allowed to execute any job");
            return;
        }
        this.scheduler.triggerJob(new JobKey(jobName, groupName));
    }

    private JobDetail findJob(String groupName, String jobName) throws SchedulerException {
        return this.scheduler.getJobDetail(new JobKey(jobName, groupName));
    }

    @Override
    public boolean removeTrigger(String groupName, String jobName, String triggerGroup, String triggerName) throws SchedulerException {
        if (!this.config.isRemoveTriggerAllowed()) {
            LOGGER.warn((Object)"not allowed to remove any trigger");
            return false;
        }
        Trigger triggerFound = this.findTrigger(groupName, jobName, triggerGroup, triggerName);
        if (null != triggerFound) {
            return this.scheduler.unscheduleJob(triggerFound.getKey());
        }
        return false;
    }

    @Override
    public JobTriggerTO getTriggerInfo(String groupName, String jobName, String triggerGroup, String triggerName) throws SchedulerException {
        JobDetail detail = this.findJob(groupName, jobName);
        JobTriggerTO triggerTO = new JobTriggerTO();
        triggerTO.setJobGroup(groupName);
        triggerTO.setJobName(jobName);
        triggerTO.setDescription(detail.getDescription());
        triggerTO.setJobData((Map<String, Object>)detail.getJobDataMap());
        if (null == triggerName) {
            return triggerTO;
        }
        Trigger trigger = this.findTrigger(groupName, jobName, triggerGroup, triggerName);
        triggerTO.setTriggerName(triggerName);
        triggerTO.setTriggerGroup(trigger.getKey().getGroup());
        triggerTO.setTriggerDescription(trigger.getDescription());
        triggerTO.setMisfireInstruction(trigger.getMisfireInstruction());
        triggerTO.setPriority(trigger.getPriority());
        triggerTO.setCalendarName(trigger.getCalendarName());
        triggerTO.setStartTime(trigger.getStartTime());
        if (this.isCronTrigger(trigger)) {
            this.addSimilarMisfireInstructionSet(triggerTO, null, JobTriggerTO.TriggerType.CRON);
            triggerTO.setCronExpression(((CronTrigger)trigger).getCronExpression());
            triggerTO.setTimeZone(((CronTrigger)trigger).getTimeZone());
        } else if (trigger instanceof SimpleTrigger) {
            this.addSimpleMisfireInstructionSet(triggerTO, null);
            triggerTO.setRepeatCount(((SimpleTrigger)trigger).getRepeatCount());
            triggerTO.setRepeatInterval(((SimpleTrigger)trigger).getRepeatInterval());
        } else if (trigger instanceof CalendarIntervalTrigger) {
            this.addSimilarMisfireInstructionSet(triggerTO, null, JobTriggerTO.TriggerType.CALENDAR);
            triggerTO.setRepeatInterval(Long.valueOf(((CalendarIntervalTrigger)trigger).getRepeatInterval()));
            triggerTO.setRepeatIntervalUnit(((CalendarIntervalTrigger)trigger).getRepeatIntervalUnit());
        } else if (trigger instanceof DailyTimeIntervalTrigger) {
            this.addSimilarMisfireInstructionSet(triggerTO, null, JobTriggerTO.TriggerType.DAILY);
            triggerTO.setRepeatInterval(Long.valueOf(((DailyTimeIntervalTrigger)trigger).getRepeatInterval()));
            triggerTO.setRepeatIntervalUnit(((DailyTimeIntervalTrigger)trigger).getRepeatIntervalUnit());
            triggerTO.setRepeatCount(((DailyTimeIntervalTrigger)trigger).getRepeatCount());
        }
        triggerTO.setJobData((Map<String, Object>)trigger.getJobDataMap());
        this.addGlobalMisfireInstructionSet(triggerTO, null);
        return triggerTO;
    }

    @Override
    public Collection<String> getCalendarNames() throws SchedulerException {
        return this.scheduler.getCalendarNames();
    }

    @Override
    public Collection<JobTriggerTO> getInstructionSets() {
        ArrayList<JobTriggerTO> instructionSets = new ArrayList<JobTriggerTO>();
        this.addSimilarMisfireInstructionSet(null, instructionSets, JobTriggerTO.TriggerType.CRON);
        this.addSimpleMisfireInstructionSet(null, instructionSets);
        this.addSimilarMisfireInstructionSet(null, instructionSets, JobTriggerTO.TriggerType.CALENDAR);
        this.addSimilarMisfireInstructionSet(null, instructionSets, JobTriggerTO.TriggerType.DAILY);
        this.addGlobalMisfireInstructionSet(null, instructionSets);
        return instructionSets;
    }

    private void addGlobalMisfireInstructionSet(JobTriggerTO jobTrigger, List<JobTriggerTO> instructionSets) {
        if (null != instructionSets) {
            for (JobTriggerTO trigger : instructionSets) {
                trigger.addMisfireInstructions("IGNORE_MISFIRE_POLICY", -1);
                trigger.addMisfireInstructions("SMART_POLICY", 0);
            }
        } else {
            jobTrigger.addMisfireInstructions("IGNORE_MISFIRE_POLICY", -1);
            jobTrigger.addMisfireInstructions("SMART_POLICY", 0);
        }
    }

    private void addSimpleMisfireInstructionSet(JobTriggerTO jobTrigger, List<JobTriggerTO> instructionSets) {
        if (null == jobTrigger) {
            jobTrigger = new JobTriggerTO();
        }
        jobTrigger.setTriggerType(JobTriggerTO.TriggerType.SIMPLE);
        jobTrigger.addMisfireInstructions("FIRE_NOW", 1);
        jobTrigger.addMisfireInstructions("RESCHEDULE_NEXT_WITH_EXISTING_COUNT", 5);
        jobTrigger.addMisfireInstructions("RESCHEDULE_NEXT_WITH_REMAINING_COUNT", 4);
        jobTrigger.addMisfireInstructions("RESCHEDULE_NOW_WITH_EXISTING_REPEAT_COUNT", 2);
        jobTrigger.addMisfireInstructions("RESCHEDULE_NOW_WITH_REMAINING_REPEAT_COUNT", 3);
        this.addSimpleRepeatIntervalUnits(jobTrigger);
        if (null != instructionSets) {
            instructionSets.add(jobTrigger);
        }
    }

    private void addSimilarMisfireInstructionSet(JobTriggerTO jobTrigger, List<JobTriggerTO> instructionSets, JobTriggerTO.TriggerType type) {
        if (null == jobTrigger) {
            jobTrigger = new JobTriggerTO();
        }
        jobTrigger.setTriggerType(type);
        jobTrigger.addMisfireInstructions("DO_NOTHING", 2);
        jobTrigger.addMisfireInstructions("FIRE_ONCE_NOW", 1);
        if (type == JobTriggerTO.TriggerType.CALENDAR || type == JobTriggerTO.TriggerType.DAILY) {
            this.addSimpleRepeatIntervalUnits(jobTrigger);
            this.addExtendedRepeatIntervalUnits(jobTrigger);
        }
        if (null != instructionSets) {
            instructionSets.add(jobTrigger);
        }
    }

    private void addSimpleRepeatIntervalUnits(JobTriggerTO jobTrigger) {
        jobTrigger.addRepeatIntervalUnits("Milliseconds", DateBuilder.IntervalUnit.MILLISECOND);
        jobTrigger.addRepeatIntervalUnits("Second", DateBuilder.IntervalUnit.SECOND);
        jobTrigger.addRepeatIntervalUnits("Minute", DateBuilder.IntervalUnit.MINUTE);
        jobTrigger.addRepeatIntervalUnits("Hour", DateBuilder.IntervalUnit.HOUR);
    }

    private void addExtendedRepeatIntervalUnits(JobTriggerTO jobTrigger) {
        jobTrigger.addRepeatIntervalUnits("Day", DateBuilder.IntervalUnit.DAY);
        jobTrigger.addRepeatIntervalUnits("Week", DateBuilder.IntervalUnit.WEEK);
        jobTrigger.addRepeatIntervalUnits("Month", DateBuilder.IntervalUnit.MONTH);
        jobTrigger.addRepeatIntervalUnits("Year", DateBuilder.IntervalUnit.YEAR);
    }

    private String nvl(String check, String defaultVal) {
        return StringUtils.isEmpty((Object)check) ? defaultVal : check;
    }

    @Override
    public boolean changeJob(JobTriggerTO triggerTO) throws SchedulerException {
        if (!this.config.isChangeJobInfoAllowed()) {
            LOGGER.warn((Object)"not allowed to change any job info");
            return false;
        }
        JobDetail detail = this.findJob(triggerTO.getOriginalJobGroup(), triggerTO.getOriginalJobName());
        if (null == detail) {
            return false;
        }
        JobBuilder builder = detail.getJobBuilder().withIdentity(this.nvl(triggerTO.getJobName(), triggerTO.getOriginalJobName()), this.nvl(triggerTO.getJobGroup(), triggerTO.getOriginalJobGroup())).withDescription(triggerTO.getDescription());
        if (null != triggerTO.getJobData() && !triggerTO.getJobData().isEmpty()) {
            for (Map.Entry<String, Object> entry : triggerTO.getJobData().entrySet()) {
                if (String.class.isAssignableFrom(entry.getValue().getClass())) {
                    builder.usingJobData(entry.getKey(), (String)entry.getValue());
                } else if (Boolean.class.isAssignableFrom(entry.getValue().getClass())) {
                    builder.usingJobData(entry.getKey(), (Boolean)entry.getValue());
                } else if (Integer.class.isAssignableFrom(entry.getValue().getClass())) {
                    builder.usingJobData(entry.getKey(), (Integer)entry.getValue());
                } else if (Long.class.isAssignableFrom(entry.getValue().getClass())) {
                    builder.usingJobData(entry.getKey(), (Long)entry.getValue());
                } else if (Double.class.isAssignableFrom(entry.getValue().getClass())) {
                    builder.usingJobData(entry.getKey(), (Double)entry.getValue());
                } else if (Float.class.isAssignableFrom(entry.getValue().getClass())) {
                    builder.usingJobData(entry.getKey(), (Float)entry.getValue());
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("jobDataEntry: " + entry.getKey() + ", val: " + entry.getValue() + ", class: " + entry.getValue().getClass()));
            }
        }
        this.scheduler.addJob(builder.build(), true, true);
        return true;
    }

    @Override
    public boolean changeTrigger(JobTriggerTO triggerTO, boolean add) throws SchedulerException {
        if (!this.config.isChangeTriggerAllowed()) {
            LOGGER.warn((Object)"not allowed to change any trigger");
            return false;
        }
        JobDetail detail = this.findJob(triggerTO.getOriginalJobGroup(), triggerTO.getOriginalJobName());
        if (null == detail) {
            return false;
        }
        Trigger trigger = this.findTrigger(triggerTO.getOriginalJobGroup(), triggerTO.getOriginalJobName(), triggerTO.getOriginalTriggerGroup(), triggerTO.getOriginalTriggerName());
        if (null == trigger) {
            if (add) {
                this.scheduler.scheduleJob(this.buildTrigger(detail, null, triggerTO));
                return true;
            }
            return false;
        }
        this.scheduler.rescheduleJob(trigger.getKey(), this.buildTrigger(detail, trigger, triggerTO));
        return true;
    }

    private Trigger buildTrigger(JobDetail detail, Trigger trigger, JobTriggerTO triggerTO) {
        TriggerBuilder builder = TriggerBuilder.newTrigger().forJob(detail).withIdentity(this.nvl(triggerTO.getTriggerName(), triggerTO.getOriginalTriggerName()), this.nvl(triggerTO.getTriggerGroup(), triggerTO.getOriginalTriggerGroup()));
        SimpleScheduleBuilder schedule = null;
        block0 : switch (triggerTO.getTriggerType()) {
            case CRON: {
                schedule = CronScheduleBuilder.cronSchedule((String)triggerTO.getCronExpression());
                if (null != triggerTO.getTimeZone()) {
                    ((CronScheduleBuilder)schedule).inTimeZone(triggerTO.getTimeZone());
                }
                switch (triggerTO.getMisfireInstruction()) {
                    case 1: {
                        ((CronScheduleBuilder)schedule).withMisfireHandlingInstructionFireAndProceed();
                        break block0;
                    }
                    case -1: {
                        ((CronScheduleBuilder)schedule).withMisfireHandlingInstructionIgnoreMisfires();
                        break block0;
                    }
                }
                ((CronScheduleBuilder)schedule).withMisfireHandlingInstructionDoNothing();
                break;
            }
            case SIMPLE: {
                schedule = SimpleScheduleBuilder.simpleSchedule();
                if (triggerTO.getRepeatCount() < 0) {
                    schedule.repeatForever();
                } else {
                    schedule.withRepeatCount(triggerTO.getRepeatCount().intValue());
                }
                switch (triggerTO.getRepeatIntervalUnit()) {
                    case MILLISECOND: {
                        schedule.withIntervalInMilliseconds(Long.valueOf(triggerTO.getRepeatInterval()).longValue());
                        break;
                    }
                    case SECOND: {
                        schedule.withIntervalInSeconds(Long.valueOf(triggerTO.getRepeatInterval()).intValue());
                        break;
                    }
                    case MINUTE: {
                        schedule.withIntervalInMinutes(Long.valueOf(triggerTO.getRepeatInterval()).intValue());
                        break;
                    }
                    case HOUR: {
                        schedule.withIntervalInHours(Long.valueOf(triggerTO.getRepeatInterval()).intValue());
                        break;
                    }
                    case DAY: {
                        schedule.withIntervalInHours(Long.valueOf(triggerTO.getRepeatInterval()).intValue() * 24);
                        break;
                    }
                    case WEEK: {
                        schedule.withIntervalInHours(Long.valueOf(triggerTO.getRepeatInterval()).intValue() * 24 * 7);
                        break;
                    }
                }
                switch (triggerTO.getMisfireInstruction()) {
                    case 5: {
                        schedule.withMisfireHandlingInstructionNextWithExistingCount();
                        break;
                    }
                    case 4: {
                        schedule.withMisfireHandlingInstructionNextWithRemainingCount();
                        break;
                    }
                    case 2: {
                        schedule.withMisfireHandlingInstructionNowWithExistingCount();
                        break;
                    }
                    case 3: {
                        schedule.withMisfireHandlingInstructionNowWithRemainingCount();
                        break;
                    }
                    case -1: {
                        schedule.withMisfireHandlingInstructionIgnoreMisfires();
                        break;
                    }
                    default: {
                        schedule.withMisfireHandlingInstructionFireNow();
                    }
                }
            }
            case CALENDAR: {
                schedule = CalendarIntervalScheduleBuilder.calendarIntervalSchedule().withInterval(Long.valueOf(triggerTO.getRepeatInterval()).intValue(), triggerTO.getRepeatIntervalUnit());
                switch (triggerTO.getMisfireInstruction()) {
                    case 1: {
                        ((CalendarIntervalScheduleBuilder)schedule).withMisfireHandlingInstructionFireAndProceed();
                        break block0;
                    }
                    case -1: {
                        ((CalendarIntervalScheduleBuilder)schedule).withMisfireHandlingInstructionIgnoreMisfires();
                        break block0;
                    }
                }
                ((CalendarIntervalScheduleBuilder)schedule).withMisfireHandlingInstructionDoNothing();
                break;
            }
            case DAILY: {
                schedule = DailyTimeIntervalScheduleBuilder.dailyTimeIntervalSchedule().withInterval(Long.valueOf(triggerTO.getRepeatInterval()).intValue(), triggerTO.getRepeatIntervalUnit()).withRepeatCount(triggerTO.getRepeatCount().intValue());
                switch (triggerTO.getMisfireInstruction()) {
                    case 1: {
                        ((DailyTimeIntervalScheduleBuilder)schedule).withMisfireHandlingInstructionFireAndProceed();
                        break block0;
                    }
                    case -1: {
                        ((DailyTimeIntervalScheduleBuilder)schedule).withMisfireHandlingInstructionIgnoreMisfires();
                        break block0;
                    }
                }
                ((DailyTimeIntervalScheduleBuilder)schedule).withMisfireHandlingInstructionDoNothing();
                break;
            }
        }
        if (null != triggerTO.getJobData() && !triggerTO.getJobData().isEmpty()) {
            for (Map.Entry<String, Object> entry : triggerTO.getJobData().entrySet()) {
                if (String.class.isAssignableFrom(entry.getValue().getClass())) {
                    builder.usingJobData(entry.getKey(), (String)entry.getValue());
                } else if (Boolean.class.isAssignableFrom(entry.getValue().getClass())) {
                    builder.usingJobData(entry.getKey(), (Boolean)entry.getValue());
                } else if (Integer.class.isAssignableFrom(entry.getValue().getClass())) {
                    builder.usingJobData(entry.getKey(), (Integer)entry.getValue());
                } else if (Long.class.isAssignableFrom(entry.getValue().getClass())) {
                    builder.usingJobData(entry.getKey(), (Long)entry.getValue());
                } else if (Double.class.isAssignableFrom(entry.getValue().getClass())) {
                    builder.usingJobData(entry.getKey(), (Double)entry.getValue());
                } else if (Float.class.isAssignableFrom(entry.getValue().getClass())) {
                    builder.usingJobData(entry.getKey(), (Float)entry.getValue());
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("jobDataEntry: " + entry.getKey() + ", val: " + entry.getValue() + ", class: " + entry.getValue().getClass()));
            }
        }
        builder.withSchedule((ScheduleBuilder)schedule);
        if (null != triggerTO.getPriority()) {
            builder.withPriority(triggerTO.getPriority().intValue());
        }
        builder.withDescription(triggerTO.getTriggerDescription());
        if (null == triggerTO.getStartTime()) {
            builder.startAt(new Date());
        } else {
            builder.startAt(triggerTO.getStartTime());
        }
        return builder.build();
    }
}

