/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.quartz;

import de.chandre.admintool.core.controller.AbstractAdminController;
import de.chandre.admintool.quartz.AdminToolQuartzConfig;
import de.chandre.admintool.quartz.AdminToolQuartzService;
import de.chandre.admintool.quartz.JobTriggerTO;
import java.util.Arrays;
import java.util.Collection;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.DateBuilder;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/admintool/quartz"})
public class AdminToolQuartzController
extends AbstractAdminController {
    private static final Log LOGGER = LogFactory.getLog(AdminToolQuartzService.class);
    @Autowired
    private AdminToolQuartzConfig config;
    @Autowired
    private AdminToolQuartzService quarzService;

    @RequestMapping(value={"/quartzJobsInc"})
    public String getJobs(ModelMap model, HttpServletRequest request) {
        if (!this.config.isEnabled()) {
            return null;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"serving quartz jobs include");
        }
        this.addCommonContextVars(model, request);
        return "admintool/quartz/includes/quartzJobs.inc";
    }

    @RequestMapping(path={"/changeRunningState"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public boolean changeRunningState() {
        if (!this.config.isEnabled()) {
            return false;
        }
        if (this.quarzService.isSchedulerRunning()) {
            this.quarzService.stopScheduler();
        } else {
            this.quarzService.startScheduler();
        }
        return this.quarzService.isSchedulerRunning();
    }

    @RequestMapping(path={"/executeJob/{jobGroup}/{jobName}"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public boolean executeJob(@PathVariable(value="jobGroup") String groupName, @PathVariable(value="jobName") String jobName, HttpServletRequest request) {
        if (!this.config.isEnabled()) {
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("receiving triggerJob request for group: %s, job: %s", groupName, jobName));
        }
        try {
            this.quarzService.triggerJob(groupName, jobName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @RequestMapping(path={"/changeTriggerState/{jobGroup}/{jobName}"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public boolean changeJobState(@PathVariable(value="jobGroup") String groupName, @PathVariable(value="jobName") String jobName, HttpServletRequest request) {
        if (!this.config.isEnabled()) {
            return false;
        }
        return this.changeJobState(groupName, jobName, null, null, request);
    }

    @RequestMapping(path={"/changeTriggerState/{jobGroup}/{jobName}/{triggerGroup}/{triggerName}"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public boolean changeJobState(@PathVariable(value="jobGroup") String groupName, @PathVariable(value="jobName") String jobName, @PathVariable(value="triggerGroup") String triggerGroup, @PathVariable(value="triggerName") String triggerName, HttpServletRequest request) {
        if (!this.config.isEnabled()) {
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("receiving changeJobState request for group: %s, job: %s, trigger: %s", groupName, jobName, triggerName));
        }
        try {
            this.quarzService.changeTriggerState(groupName, jobName, triggerGroup, triggerName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @RequestMapping(path={"/interruptJob/{jobGroup}/{jobName}"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public boolean interruptJob(@PathVariable(value="jobGroup") String groupName, @PathVariable(value="jobName") String jobName, HttpServletRequest request) {
        if (!this.config.isEnabled()) {
            return false;
        }
        return this.interruptJob(groupName, jobName, null, null, request);
    }

    @RequestMapping(path={"/interruptJob/{jobGroup}/{jobName}/{triggerGroup}/{triggerName}"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public boolean interruptJob(@PathVariable(value="jobGroup") String groupName, @PathVariable(value="jobName") String jobName, @PathVariable(value="triggerGroup") String triggerGroup, @PathVariable(value="triggerName") String triggerName, HttpServletRequest request) {
        if (!this.config.isEnabled()) {
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("receiving interruptJob request for group: %s, job: %s", groupName, jobName));
        }
        try {
            if (null != triggerName) {
                this.quarzService.interruptTrigger(groupName, jobName, triggerGroup, triggerName);
            } else {
                this.quarzService.interruptJob(groupName, jobName);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    @RequestMapping(path={"/removeTrigger/{jobGroup}/{jobName}"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public boolean removeTrigger(@PathVariable(value="jobGroup") String groupName, @PathVariable(value="jobName") String jobName, HttpServletRequest request) {
        if (!this.config.isEnabled()) {
            return false;
        }
        return this.removeTrigger(groupName, jobName, null, null, request);
    }

    @RequestMapping(path={"/removeTrigger/{jobGroup}/{jobName}/{triggerGroup}/{triggerName}"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public boolean removeTrigger(@PathVariable(value="jobGroup") String groupName, @PathVariable(value="jobName") String jobName, @PathVariable(value="triggerGroup") String triggerGroup, @PathVariable(value="triggerName") String triggerName, HttpServletRequest request) {
        if (!this.config.isEnabled()) {
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("receiving removeTrigger request for group: %s, job: %s, trigger: %s", groupName, jobName, triggerName));
        }
        try {
            return this.quarzService.removeTrigger(groupName, jobName, triggerGroup, triggerName);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public JobTriggerTO getJobTriggerInfo(String groupName, String jobName, String triggerGroup, String triggerName, String methodName, HttpServletRequest request) {
        if (!this.config.isEnabled()) {
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("receiving %s request for group: %s, job: %s, trigger: %s", methodName, groupName, jobName, triggerName));
        }
        try {
            return this.quarzService.getTriggerInfo(groupName, jobName, triggerGroup, triggerName);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @RequestMapping(path={"/getTriggerInfo/{jobGroup}/{jobName}"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public JobTriggerTO getJobInfo(@PathVariable(value="jobGroup") String jobGroup, @PathVariable(value="jobName") String jobName, HttpServletRequest request) {
        if (!this.config.isEnabled()) {
            return null;
        }
        return this.getJobTriggerInfo(jobGroup, jobName, null, null, "getJobInfo", request);
    }

    @RequestMapping(path={"/getTriggerInfo/{jobGroup}/{jobName}/{triggerGroup}/{triggerName}"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public JobTriggerTO getTriggerInfo(@PathVariable(value="jobGroup") String jobGroup, @PathVariable(value="jobName") String jobName, @PathVariable(value="triggerGroup") String triggerGroup, @PathVariable(value="triggerName") String triggerName, HttpServletRequest request) {
        if (!this.config.isEnabled()) {
            return null;
        }
        return this.getJobTriggerInfo(jobGroup, jobName, triggerGroup, triggerName, "getTriggerInfo", request);
    }

    @RequestMapping(path={"/getDefaultTimeZone"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public String getDefaultTimeZone(HttpServletRequest request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"receiving getDefaultTimeZone request");
        }
        return TimeZone.getDefault().getID();
    }

    @RequestMapping(path={"/getTimeZones"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public String[] getTimeZones(HttpServletRequest request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"receiving getTimeZones request");
        }
        return TimeZone.getAvailableIDs();
    }

    @RequestMapping(path={"/getInstructionSets"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Collection<JobTriggerTO> getMisfireInstructions(HttpServletRequest request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"receiving getMisfireInstructions request");
        }
        return this.quarzService.getInstructionSets();
    }

    @RequestMapping(path={"/getCalendarNames"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Collection<String> getCalendarNames(HttpServletRequest request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"receiving getCalendarNames request");
        }
        try {
            return this.quarzService.getCalendarNames();
        }
        catch (SchedulerException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @RequestMapping(path={"/getIntervalUnits"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Collection<DateBuilder.IntervalUnit> getIntervalUnits(HttpServletRequest request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"receiving getCalendarNames request");
        }
        return Arrays.asList(DateBuilder.IntervalUnit.values());
    }

    @RequestMapping(path={"/changeTrigger"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean changeTrigger(@RequestBody JobTriggerTO triggerTO, HttpServletRequest request) {
        if (!this.config.isEnabled()) {
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("receiving changeTrigger request: %s", triggerTO));
        }
        try {
            return this.quarzService.changeTrigger(triggerTO, false);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @RequestMapping(path={"/addTrigger"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean addTrigger(@RequestBody JobTriggerTO triggerTO, HttpServletRequest request) {
        if (!this.config.isEnabled()) {
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("receiving addTrigger request: %s", triggerTO));
        }
        try {
            return this.quarzService.changeTrigger(triggerTO, true);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @RequestMapping(path={"/changeJob"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean changeJob(@RequestBody JobTriggerTO triggerTO, HttpServletRequest request) {
        if (!this.config.isEnabled()) {
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("receiving changeJob request: %s", triggerTO));
        }
        try {
            return this.quarzService.changeJob(triggerTO);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public AdminToolQuartzService getQuarzService() {
        return this.quarzService;
    }

    public void setQuarzService(AdminToolQuartzService quarzService) {
        this.quarzService = quarzService;
    }
}

