/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.properties;

import de.chandre.admintool.properties.AdminToolPropertiesConfig;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="adminToolPropertiesService")
public class AdminToolPropertiesService {
    private static final Log LOGGER = LogFactory.getLog(AdminToolPropertiesService.class);
    private Map<String, String> gitProperties = new TreeMap<String, String>();
    private boolean loaded = false;
    @Autowired
    private ConfigurableEnvironment env;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private AdminToolPropertiesConfig config;

    public synchronized boolean hasGitProperties() {
        if (this.gitProperties.isEmpty()) {
            this.loadGitProperties();
        }
        return !this.gitProperties.isEmpty();
    }

    public synchronized Map<String, String> getGitProperties() {
        if (!this.loaded) {
            this.loadGitProperties();
        }
        return this.gitProperties;
    }

    private void loadGitProperties() {
        try {
            Resource gitResource = this.applicationContext.getResource(this.config.getGitPropertiesPath());
            InputStreamReader reader = new InputStreamReader(gitResource.getInputStream(), this.config.getGitPropertiesEncoding());
            Properties p = new Properties();
            p.load(reader);
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                this.gitProperties.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
            this.loaded = true;
        }
        catch (Exception e) {
            LOGGER.debug((Object)e.getMessage(), (Throwable)e);
        }
    }

    public Map<String, String> getEnvProperty() {
        TreeMap<String, String> res = new TreeMap<String, String>();
        MutablePropertySources mps = this.env.getPropertySources();
        for (PropertySource ps : mps) {
            if (!(ps instanceof EnumerablePropertySource)) continue;
            for (String propName : ((EnumerablePropertySource)ps).getPropertyNames()) {
                res.put(propName, this.env.getProperty(propName));
            }
        }
        return res;
    }

    public Map<Integer, String> getAdditionalProperyNames() {
        if (CollectionUtils.isEmpty(this.config.getAddPropertiesPaths())) {
            return Collections.emptyMap();
        }
        TreeMap<Integer, String> propertyNames = new TreeMap<Integer, String>();
        for (String path : this.config.getAddPropertiesPaths()) {
            try {
                propertyNames.put(path.hashCode(), this.applicationContext.getResource(path).getFilename());
            }
            catch (Exception e) {
                LOGGER.error((Object)("could not load additional property: " + e.getMessage()), (Throwable)e);
            }
        }
        return propertyNames;
    }

    public Map<Object, Object> getAdditionalProperies(Integer hashKey) {
        if (CollectionUtils.isEmpty(this.config.getAddPropertiesPaths()) || null == hashKey) {
            return Collections.emptyMap();
        }
        try {
            for (String path : this.config.getAddPropertiesPaths()) {
                if (path.hashCode() != hashKey.intValue()) continue;
                Resource resource = this.applicationContext.getResource(path);
                InputStreamReader reader = new InputStreamReader(resource.getInputStream(), this.config.getGitPropertiesEncoding());
                Properties p = new Properties();
                p.load(reader);
                return p;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyMap();
    }
}

