/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.properties;

import de.chandre.admintool.core.AbstractAdminToolLoader;
import de.chandre.admintool.core.AdminTool;
import de.chandre.admintool.core.component.AdminComponent;
import de.chandre.admintool.core.component.AdminComponentImpl;
import de.chandre.admintool.core.component.MenuEntry;
import de.chandre.admintool.properties.AdminToolPropertiesConfig;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AdminToolPropertiesLoader
extends AbstractAdminToolLoader {
    private static final Log LOGGER = LogFactory.getLog(AdminToolPropertiesLoader.class);
    @Autowired
    private AdminTool adminTool;
    @Autowired
    private AdminToolPropertiesConfig config;

    @PostConstruct
    public void configureAdminTool() {
        if (!this.coreConfig.isEnabled() || !this.config.isEnabled()) {
            LOGGER.info((Object)"admin tool's properties visualizer is deactivated");
            return;
        }
        LOGGER.info((Object)"adding properties visualizer to admin tool");
        LOGGER.debug((Object)((Object)((Object)this)).toString());
        AdminComponentImpl component = new AdminComponentImpl();
        component.setPosition(this.config.getComponentPosition());
        component.getSecurityRoles().addAll(this.config.getSecurityRoles());
        component.setDisplayName("Properties");
        component.addAdditionalJS("/static/admintool/js/properties.js", true);
        MenuEntry mainMenu = new MenuEntry();
        mainMenu.setDisplayName("Properties");
        mainMenu.setName("properties");
        mainMenu.setTarget("properties/content/properties");
        component.setMainMenu(mainMenu);
        this.adminTool.addComponent((AdminComponent)component);
    }
}

