/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.properties;

import de.chandre.admintool.core.AdminToolConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="adminToolPropertiesConfig")
public class AdminToolPropertiesConfig
implements AdminToolConfig {
    private static final Log LOGGER = LogFactory.getLog(AdminToolPropertiesConfig.class);
    private static final String GIT_PROPS_PATH_DEFAULT = "classpath:git.properties";
    @Value(value="${adminTool.properties.enabled:true}")
    private boolean enabled;
    @Value(value="${admintool.properties.gitPropertiesPath:}")
    private String gitPropertiesPath;
    @Value(value="${admintool.properties.gitPropertiesEncoding:UTF-8}")
    private String gitPropertiesEncoding;
    @Value(value="#{'${admintool.properties.securityRoles:}'.split(';')}")
    private Set<String> securityRoles = new HashSet<String>();
    @Value(value="${admintool.properties.componentPosition:}")
    private Integer componentPosition;
    @Value(value="#{'${admintool.properties.addPropertiesPaths:}'.split(';')}")
    private List<String> addPropertiesPaths;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Set<String> getSecurityRoles() {
        return this.securityRoles;
    }

    public String getGitPropertiesPath() {
        if (StringUtils.isEmpty((Object)this.gitPropertiesPath)) {
            return GIT_PROPS_PATH_DEFAULT;
        }
        return this.gitPropertiesPath;
    }

    public String getGitPropertiesEncoding() {
        return this.gitPropertiesEncoding;
    }

    public Integer getComponentPosition() {
        return this.componentPosition;
    }

    public void setComponentPosition(Integer componentPosition) {
        this.componentPosition = componentPosition;
    }

    public void setGitPropertiesPath(String gitPropertiesPath) {
        this.gitPropertiesPath = gitPropertiesPath;
    }

    public void setGitPropertiesEncoding(String gitPropertiesEncoding) {
        this.gitPropertiesEncoding = gitPropertiesEncoding;
    }

    public void setSecurityRoles(Set<String> securityRoles) {
        this.securityRoles = securityRoles;
    }

    public List<String> getAddPropertiesPaths() {
        return this.addPropertiesPaths;
    }

    public void setAddPropertiesPaths(List<String> addPropertiesPaths) {
        this.addPropertiesPaths = addPropertiesPaths;
    }

    public void printConfig() {
        LOGGER.info((Object)this.toString());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AdminToolPropertiesConfig [enabled=").append(this.enabled).append(", gitPropertiesPath=").append(this.gitPropertiesPath).append(", gitPropertiesEncoding=").append(this.gitPropertiesEncoding).append(", securityRoles=").append(this.securityRoles).append(", componentPosition=").append(this.componentPosition).append(", addPropertiesPaths=").append(this.addPropertiesPaths).append("]");
        return builder.toString();
    }
}

