/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.properties;

import de.chandre.admintool.properties.AdminToolPropertiesLoader;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service(value="adminToolPropertiesService")
public class AdminToolPropertiesService {
    private static final Log LOGGER = LogFactory.getLog(AdminToolPropertiesService.class);
    private Map<String, String> gitProperties = new TreeMap<String, String>();
    private boolean loaded = false;
    @Autowired
    private ConfigurableEnvironment env;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private AdminToolPropertiesLoader loader;

    public synchronized boolean hasGitProperties() {
        if (this.gitProperties.isEmpty()) {
            this.loadGitProperties();
        }
        return !this.gitProperties.isEmpty();
    }

    public synchronized Map<String, String> getGitProperties() {
        if (!this.loaded) {
            this.loadGitProperties();
        }
        return this.gitProperties;
    }

    private void loadGitProperties() {
        try {
            Resource gitResource = this.applicationContext.getResource(this.loader.getGitPropertiesPath());
            InputStreamReader reader = new InputStreamReader(gitResource.getInputStream(), this.loader.getGitPropertiesEncoding());
            Properties p = new Properties();
            p.load(reader);
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                this.gitProperties.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
            this.loaded = true;
        }
        catch (Exception e) {
            LOGGER.debug((Object)e.getMessage(), (Throwable)e);
        }
    }

    public Map<String, String> getEnvProperty() {
        TreeMap<String, String> res = new TreeMap<String, String>();
        MutablePropertySources mps = this.env.getPropertySources();
        for (PropertySource ps : mps) {
            if (!(ps instanceof EnumerablePropertySource)) continue;
            for (String propName : ((EnumerablePropertySource)ps).getPropertyNames()) {
                res.put(propName, this.env.getProperty(propName));
            }
        }
        return res;
    }
}

