/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.properties;

import de.chandre.admintool.core.AbstractAdminToolLoader;
import de.chandre.admintool.core.AdminTool;
import de.chandre.admintool.core.component.AdminComponent;
import de.chandre.admintool.core.component.AdminComponentImpl;
import de.chandre.admintool.core.component.MenuEntry;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class AdminToolPropertiesLoader
extends AbstractAdminToolLoader {
    private static final Log LOGGER = LogFactory.getLog(AdminToolPropertiesLoader.class);
    private static final String GIT_PROPS_PATH_DEFAULT = "classpath:git.properties";
    @Autowired
    private AdminTool adminTool;
    @Value(value="${admintool.properties.gitPropertiesPath:}")
    private String gitPropertiesPath;
    @Value(value="${admintool.properties.gitPropertiesEncoding:UTF-8}")
    private String gitPropertiesEncoding;
    @Value(value="#{'${admintool.properties.securityRoles:}'.split(';')}")
    private Set<String> securityRoles = new HashSet<String>();
    @Value(value="${admintool.properties.componentPosition:}")
    private Integer componentPosition;

    @PostConstruct
    public void configureAdminTool() {
        if (!this.coreConfig.isEnabled()) {
            LOGGER.info((Object)"admin tool's properties visualizer is deactivated");
            return;
        }
        LOGGER.info((Object)"adding properties visualizer to admin tool");
        LOGGER.debug((Object)this.toString());
        AdminComponentImpl component = new AdminComponentImpl();
        component.setPosition(this.componentPosition);
        component.getSecurityRoles().addAll(this.securityRoles);
        component.setDisplayName("Properties");
        component.addAdditionalJS("/static/admintool/js/properties.js", true);
        MenuEntry mainMenu = new MenuEntry();
        mainMenu.setDisplayName("Properties");
        mainMenu.setName("properties");
        mainMenu.setTarget("properties/content/properties");
        component.setMainMenu(mainMenu);
        this.adminTool.addComponent((AdminComponent)component);
    }

    public Set<String> getSecurityRoles() {
        return this.securityRoles;
    }

    public String getGitPropertiesPath() {
        if (StringUtils.isEmpty((Object)this.gitPropertiesPath)) {
            return GIT_PROPS_PATH_DEFAULT;
        }
        return this.gitPropertiesPath;
    }

    public String getGitPropertiesEncoding() {
        return this.gitPropertiesEncoding;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AdminToolPropertiesLoader [gitPropertiesPath=").append(this.gitPropertiesPath).append(", gitPropertiesEncoding=").append(this.gitPropertiesEncoding).append(", securityRoles=").append(this.securityRoles).append(", componentPosition=").append(this.componentPosition).append("]");
        return builder.toString();
    }
}

