/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.melody;

import de.chandre.admintool.core.AbstractAdminToolLoader;
import de.chandre.admintool.core.AdminTool;
import de.chandre.admintool.core.component.AdminComponent;
import de.chandre.admintool.core.component.AdminComponentImpl;
import de.chandre.admintool.core.component.MenuEntry;
import de.chandre.admintool.melody.AdminToolJavaMelodyConfig;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AdminToolJavaMelodyLoader
extends AbstractAdminToolLoader {
    private static final Log LOGGER = LogFactory.getLog(AdminToolJavaMelodyLoader.class);
    @Autowired
    private AdminTool adminTool;
    @Autowired
    private AdminToolJavaMelodyConfig config;

    @PostConstruct
    public void configureAdminTool() {
        if (!this.coreConfig.isEnabled() || !this.config.isEnabled()) {
            LOGGER.info((Object)"admin tool's javaMelody view integration is deactivated");
            return;
        }
        LOGGER.info((Object)"adding JavaMelody view to admin tool");
        LOGGER.debug((Object)((Object)((Object)this)).toString());
        AdminComponentImpl component = new AdminComponentImpl();
        component.setPosition(this.config.getComponentPosition());
        component.getSecurityRoles().addAll(this.config.getSecurityRoles());
        component.setDisplayName("JavaMelody");
        component.addAdditionalCSS("/static/admintool/melody.css", true);
        MenuEntry mainMenu = new MenuEntry();
        mainMenu.setDisplayName("JavaMelody");
        mainMenu.setName("javamelody");
        mainMenu.setTarget("content/melody");
        mainMenu.addVariable("melodyPath", (Object)this.config.getMelodyPath());
        component.setMainMenu(mainMenu);
        this.adminTool.addComponent((AdminComponent)component);
    }
}

