/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.melody;

import de.chandre.admintool.core.AbstractAdminToolLoader;
import de.chandre.admintool.core.AdminTool;
import de.chandre.admintool.core.component.AdminComponent;
import de.chandre.admintool.core.component.AdminComponentImpl;
import de.chandre.admintool.core.component.MenuEntry;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AdminToolJavaMelodyLoader
extends AbstractAdminToolLoader {
    private static final Log LOGGER = LogFactory.getLog(AdminToolJavaMelodyLoader.class);
    @Autowired
    private AdminTool adminTool;
    @Value(value="${adminTool.melody.path:/monitoring}")
    private String melodyPath;
    @Value(value="#{'${admintool.melody.securityRoles:}'.split(';')}")
    private Set<String> securityRoles = new HashSet<String>();
    @Value(value="${admintool.melody.componentPosition:}")
    private Integer componentPosition;

    @PostConstruct
    public void configureAdminTool() {
        if (!this.coreConfig.isEnabled()) {
            LOGGER.info((Object)"admin tool's javaMelody view integration is deactivated");
            return;
        }
        LOGGER.info((Object)"adding JavaMelody view to admin tool");
        LOGGER.debug((Object)this.toString());
        AdminComponentImpl component = new AdminComponentImpl();
        component.setPosition(this.componentPosition);
        component.getSecurityRoles().addAll(this.securityRoles);
        component.setDisplayName("JavaMelody");
        component.addAdditionalCSS("/static/admintool/melody.css", true);
        MenuEntry mainMenu = new MenuEntry();
        mainMenu.setDisplayName("JavaMelody");
        mainMenu.setName("javamelody");
        mainMenu.setTarget("content/melody");
        mainMenu.addVariable("melodyPath", (Object)this.melodyPath);
        component.setMainMenu(mainMenu);
        this.adminTool.addComponent((AdminComponent)component);
    }

    public Set<String> getSecurityRoles() {
        return this.securityRoles;
    }

    public String getMelodyPath() {
        return this.melodyPath;
    }

    public void setMelodyPath(String melodyPath) {
        this.melodyPath = melodyPath;
    }

    public Integer getComponentPosition() {
        return this.componentPosition;
    }

    public void setComponentPosition(Integer componentPosition) {
        this.componentPosition = componentPosition;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AdminToolJavaMelodyLoader [melodyPath=").append(this.melodyPath).append(", securityRoles=").append(this.securityRoles).append(", componentPosition=").append(this.componentPosition).append("]");
        return builder.toString();
    }
}

