/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.melody;

import de.chandre.admintool.core.AdminTool;
import de.chandre.admintool.core.component.AdminComponent;
import de.chandre.admintool.core.component.AdminComponentImpl;
import de.chandre.admintool.core.component.MenuEntry;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AdminToolJavaMelodyLoader {
    private static final Log LOGGER = LogFactory.getLog(AdminToolJavaMelodyLoader.class);
    @Autowired
    private AdminTool adminTool;
    @Value(value="${adminTool.melodyPath:/monitoring}")
    private String melodyPath;

    @PostConstruct
    public AdminTool configureAdminTool() {
        LOGGER.info((Object)"adding JavaMelody view to admin tool");
        AdminComponentImpl component = new AdminComponentImpl();
        component.setDisplayName("JavaMelody");
        component.addAdditionalCSS("/static/admintool/melody.css", true);
        MenuEntry mainMenu = new MenuEntry();
        mainMenu.setDisplayName("JavaMelody");
        mainMenu.setName("javamelody");
        mainMenu.setTarget("content/melody");
        mainMenu.addVariable("melodyPath", (Object)this.melodyPath);
        component.setMainMenu(mainMenu);
        this.adminTool.addComponent((AdminComponent)component);
        return this.adminTool;
    }
}

