/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.jminix;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import de.chandre.admintool.jminix.AdminToolJmxService;
import de.chandre.admintool.jmx.jstree.JmxExecuteTO;
import de.chandre.admintool.jmx.jstree.JmxMethodTO;
import de.chandre.admintool.jmx.jstree.JmxOperationTO;
import de.chandre.admintool.jmx.jstree.JmxQueryTO;
import de.chandre.admintool.jmx.jstree.JmxResponseTO;
import de.chandre.admintool.jmx.jstree.JsTree;
import de.chandre.admintool.jmx.jstree.JsTreeState;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminToolJmxServiceImpl
implements AdminToolJmxService {
    private static final Log LOGGER = LogFactory.getLog(AdminToolJmxServiceImpl.class);
    private static final String ROLE = "role";
    private static final String GETTER = "getter";
    private static final String SERVER_ID = "MBeanServerId";
    private static final List<String> SIMPLE_TYPES = Arrays.asList("boolean", "byte", "short", "int", "long", "double", "float");
    private static String stringArraySeparator = ";";
    private Map<String, String> serverReferences = new HashMap<String, String>();
    @Autowired(required=false)
    private ObjectMapper objectMapper;
    private static final String US = "_";
    private static final String TYPE_SERVER = "server";
    private static final String TYPE_DOMAIN = "domain";
    private static final String TYPE_MBEAN = "mbean";
    private static final String TYPE_ATTRIBUTES = "attributes";
    private static final String TYPE_ATTRIBUTE = "attribute";
    private static final String TYPE_OPERATIONS = "operations";
    private static final String TYPE_OPERATION = "operation";

    @PostConstruct
    public void init() {
        try {
            ManagementFactory.getPlatformMBeanServer();
        }
        catch (Exception e) {
            LOGGER.error((Object)("no access to PlatformMBeanServer: " + e.getMessage()));
        }
        try {
            int i = -1;
            for (String serverId : this.getServerIds()) {
                this.serverReferences.put(String.valueOf(++i), serverId);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("could not retrieve serverIds: " + e.getMessage()));
        }
        if (null == this.objectMapper) {
            LOGGER.warn((Object)"no objectMapper found, creating new one");
            this.objectMapper = new ObjectMapper();
        }
    }

    private List<MBeanServer> getServers() {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        return servers;
    }

    private List<String> getServerIds() {
        List<MBeanServer> servers = this.getServers();
        ArrayList<String> serverIds = new ArrayList<String>();
        for (MBeanServer mBeanServer : servers) {
            try {
                serverIds.add((String)mBeanServer.getAttribute(MBeanServerDelegate.DELEGATE_NAME, SERVER_ID));
            }
            catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException e) {
                LOGGER.error((Object)("could not retrieve serverId: " + e.getMessage()));
            }
        }
        return serverIds;
    }

    private MBeanServer findServerByMappingKey(String serverMappingKey) {
        String agentId = this.serverReferences.get(serverMappingKey);
        if (null != agentId) {
            ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(agentId);
            if (null != servers && servers.size() == 1) {
                return (MBeanServer)servers.iterator().next();
            }
            throw new IllegalStateException("could not obtain correct server because mbean server list has a size of: " + (null != servers ? Integer.valueOf(servers.size()) : "null"));
        }
        throw new NullPointerException("could not obtain correct mbean server");
    }

    @Override
    public Map<String, String> getServerMappings() {
        return Collections.unmodifiableMap(this.serverReferences);
    }

    @Override
    public List<String> getDomains(String serverMappingKey) {
        MBeanServer server = this.findServerByMappingKey(serverMappingKey);
        List<String> domains = Arrays.asList(server.getDomains());
        Collections.sort(domains);
        return domains;
    }

    @Override
    public List<String> getMBeans(String serverMappingKey, String domain) {
        MBeanServer server = this.findServerByMappingKey(serverMappingKey);
        try {
            Set<ObjectName> names = server.queryNames(new ObjectName(domain + ":*"), null);
            ArrayList<String> result = new ArrayList<String>();
            for (ObjectName name : names) {
                result.add(((Object)name).toString().substring(domain.length() + 1));
            }
            Collections.sort(result);
            return result;
        }
        catch (MalformedObjectNameException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<MBeanAttributeInfo> getAttributes(String serverMappingKey, String domain, String mbean) {
        MBeanServer server = this.findServerByMappingKey(serverMappingKey);
        try {
            ArrayList<MBeanAttributeInfo> result = new ArrayList<MBeanAttributeInfo>(Arrays.asList(server.getMBeanInfo(new ObjectName(domain + ":" + mbean)).getAttributes()));
            Iterator i = result.iterator();
            while (i.hasNext()) {
                if (((MBeanAttributeInfo)i.next()).isReadable()) continue;
                i.remove();
            }
            Collections.sort(result, new Comparator<MBeanAttributeInfo>(){

                @Override
                public int compare(MBeanAttributeInfo o1, MBeanAttributeInfo o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            return result;
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public JmxResponseTO getAttributes(JmxQueryTO queryTo) {
        List<MBeanAttributeInfo> attributes = this.getAttributes(queryTo.getServer(), queryTo.getDomain(), queryTo.getMbean());
        JmxResponseTO response = new JmxResponseTO();
        for (MBeanAttributeInfo mBeanAttributeInfo : attributes) {
            boolean add = false;
            if (StringUtils.isEmpty((CharSequence)queryTo.getName())) {
                add = true;
            } else if (queryTo.getName().equals(mBeanAttributeInfo.getName())) {
                add = true;
            }
            JmxMethodTO method = new JmxMethodTO();
            method.setName(mBeanAttributeInfo.getName());
            method.setDescription(mBeanAttributeInfo.getDescription());
            method.setType(mBeanAttributeInfo.getType());
            method.setValue(this.getAttributeValue(queryTo, mBeanAttributeInfo.getName()));
            if (!add) continue;
            response.addMethod(method);
        }
        return response;
    }

    @Override
    public JmxResponseTO getOpperation(JmxQueryTO queryTo) {
        List<MBeanOperationInfo> opperations = this.getOperations(queryTo.getServer(), queryTo.getDomain(), queryTo.getMbean());
        JmxResponseTO response = new JmxResponseTO();
        for (MBeanOperationInfo mBeanOperationInfo : opperations) {
            MBeanParameterInfo[] parameterInfo;
            if (null == queryTo.getName() || !queryTo.getName().equals(mBeanOperationInfo.getName())) continue;
            JmxOperationTO method = new JmxOperationTO();
            method.setName(mBeanOperationInfo.getName());
            method.setDescription(mBeanOperationInfo.getDescription());
            method.setType(mBeanOperationInfo.getReturnType());
            for (MBeanParameterInfo mBeanParameterInfo : parameterInfo = mBeanOperationInfo.getSignature()) {
                JmxMethodTO parameter = new JmxMethodTO();
                parameter.setName(mBeanParameterInfo.getName());
                parameter.setDescription(mBeanParameterInfo.getDescription());
                parameter.setType(mBeanParameterInfo.getType());
                parameter.setGeneralType(AdminToolJmxServiceImpl.getGeneralType(mBeanParameterInfo.getType()));
                if (!SIMPLE_TYPES.contains(mBeanParameterInfo.getType())) {
                    parameter.setNotPrimitive(Boolean.TRUE);
                }
                method.addParameter(parameter);
            }
            response.addMethod(method);
        }
        return response;
    }

    @Override
    public JmxResponseTO getExecuteOperation(JmxExecuteTO queryTo) throws Exception {
        List<MBeanOperationInfo> opperations = this.getOperations(queryTo.getServer(), queryTo.getDomain(), queryTo.getMbean());
        JmxResponseTO response = this.getOpperation(queryTo);
        try {
            for (MBeanOperationInfo mBeanOperationInfo : opperations) {
                if (null == queryTo.getName() || !queryTo.getName().equals(mBeanOperationInfo.getName())) continue;
                MBeanParameterInfo[] parameterInfo = mBeanOperationInfo.getSignature();
                Object[] values = new Object[parameterInfo.length];
                String[] signatures = new String[parameterInfo.length];
                int i = 0;
                for (MBeanParameterInfo mBeanParameterInfo : parameterInfo) {
                    for (JmxMethodTO method : queryTo.getParameters()) {
                        if (!method.getName().equals(mBeanParameterInfo.getName())) continue;
                        signatures[i] = mBeanParameterInfo.getType();
                        values[i] = this.parse(method.getNewValue(), AdminToolJmxServiceImpl.getAttributeType(mBeanParameterInfo.getType(), method), !method.isSetToEmpty());
                        ++i;
                    }
                }
                MBeanServer server = this.findServerByMappingKey(queryTo.getServer());
                Object result = server.invoke(new ObjectName(queryTo.getDomain() + ":" + queryTo.getMbean()), queryTo.getName(), values, signatures);
                response.setReturnValue(result);
            }
            response.setSuccess(Boolean.TRUE);
        }
        catch (InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setSuccess(Boolean.FALSE);
            response.setReturnValue("Exception: " + e.getMessage());
        }
        return response;
    }

    protected static String getAttributeType(String originalType, JmxMethodTO method) {
        if (null == method || StringUtils.isBlank((CharSequence)method.getTypeInstance())) {
            return originalType;
        }
        return method.getTypeInstance();
    }

    protected Object getAttributeValue(JmxQueryTO queryTo, String attributeName) {
        try {
            String name = null == attributeName ? queryTo.getName() : attributeName;
            MBeanServer server = this.findServerByMappingKey(queryTo.getServer());
            Object value = server.getAttribute(new ObjectName(queryTo.getDomain() + ":" + queryTo.getMbean()), name);
            if (null == value) {
                return "null";
            }
            return value;
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return "[error retrieving value]";
        }
    }

    protected static String getGeneralType(String type) {
        if (type == null) {
            return type;
        }
        if (SIMPLE_TYPES.contains(type)) {
            return type;
        }
        try {
            Class<?> clazz = Class.forName(type);
            if (Collection.class.isAssignableFrom(clazz)) {
                return Collection.class.getName();
            }
            if (Map.class.isAssignableFrom(clazz)) {
                return Map.class.getName();
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.trace((Object)e.getMessage(), (Throwable)e);
        }
        return type;
    }

    public Object parse(String value, String type, boolean nullable) throws JsonParseException, JsonMappingException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object result = null;
        if (!SIMPLE_TYPES.contains(type)) {
            if ("".equals(value) && nullable) {
                Class<?> clazz = Class.forName(type);
                return clazz.newInstance();
            }
            if (type.equals(String.class.getName())) {
                return value;
            }
            if (type.equals("[Ljava.lang.String;")) {
                result = StringUtils.splitPreserveAllTokens((String)value, (String)stringArraySeparator);
            } else {
                Class<?> clazz = Class.forName(type);
                result = this.objectMapper.readValue(value, clazz);
            }
        } else if (StringUtils.isNotBlank((CharSequence)value)) {
            if (type.equals("byte")) {
                return (byte)Byte.valueOf(value);
            }
            if (type.equals("short")) {
                return (short)Short.valueOf(value);
            }
            if (type.equals("int")) {
                return (int)Integer.valueOf(value);
            }
            if (type.equals("long")) {
                return (long)Long.valueOf(value);
            }
            if (type.equals("double")) {
                return (double)Double.valueOf(value);
            }
            if (type.equals("float")) {
                return Float.valueOf(Float.valueOf(value).floatValue());
            }
            if (type.equals("boolean")) {
                return (boolean)Boolean.valueOf(value);
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("Type " + type + " with value " + value + " is not supported");
        }
        return result;
    }

    @Override
    public List<MBeanOperationInfo> getOperations(String serverMappingKey, String domain, String mbean) {
        MBeanServer server = this.findServerByMappingKey(serverMappingKey);
        try {
            ArrayList<MBeanOperationInfo> result = new ArrayList<MBeanOperationInfo>(Arrays.asList(server.getMBeanInfo(new ObjectName(domain + ":" + mbean)).getOperations()));
            Iterator i = result.iterator();
            while (i.hasNext()) {
                MBeanOperationInfo info = (MBeanOperationInfo)i.next();
                Object role = info.getDescriptor().getFieldValue(ROLE);
                if (null != role && !GETTER.equals(role)) continue;
                i.remove();
            }
            Collections.sort(result, new Comparator<MBeanOperationInfo>(){

                @Override
                public int compare(MBeanOperationInfo o1, MBeanOperationInfo o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            return result;
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<JsTree> buildTree() {
        ArrayList<JsTree> result = new ArrayList<JsTree>();
        Map<String, String> serverMappings = this.getServerMappings();
        boolean open = true;
        for (String serverKey : serverMappings.keySet()) {
            JsTree root = new JsTree(serverKey, "Server[" + serverKey + "]", TYPE_SERVER);
            root.setState(new JsTreeState(open, false, false));
            for (String domain : this.getDomains(serverKey)) {
                JsTree node1 = new JsTree(domain, domain, TYPE_DOMAIN);
                for (String mbean : this.getMBeans(serverKey, domain)) {
                    List<MBeanOperationInfo> oinfos;
                    JsTree node2 = new JsTree(mbean, mbean, TYPE_MBEAN);
                    List<MBeanAttributeInfo> ainfos = this.getAttributes(serverKey, domain, mbean);
                    if (null != ainfos) {
                        JsTree attrs = new JsTree(mbean + US + TYPE_ATTRIBUTES, "Attributes", TYPE_ATTRIBUTES);
                        node2.addChildren(attrs);
                        for (MBeanAttributeInfo ainfo : ainfos) {
                            JsTree node3 = new JsTree(mbean + US + TYPE_ATTRIBUTE + US + ainfo.getName(), ainfo.getName(), TYPE_ATTRIBUTE);
                            attrs.addChildren(node3);
                        }
                    }
                    if (null != (oinfos = this.getOperations(serverKey, domain, mbean))) {
                        JsTree ops = new JsTree(mbean + US + TYPE_OPERATIONS, "Operations", TYPE_OPERATIONS);
                        node2.addChildren(ops);
                        for (MBeanOperationInfo oinfo : oinfos) {
                            JsTree node3 = new JsTree(mbean + US + TYPE_OPERATION + US + oinfo.getName(), oinfo.getName(), TYPE_OPERATION);
                            ops.addChildren(node3);
                        }
                    }
                    node1.addChildren(node2);
                }
                root.addChildren(node1);
            }
            result.add(root);
            open = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String buildJson() throws JsonProcessingException {
        long start = System.currentTimeMillis();
        try {
            this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            String string = this.objectMapper.writeValueAsString(this.buildTree());
            return string;
        }
        finally {
            LOGGER.info((Object)("building json took " + (System.currentTimeMillis() - start) + "ms"));
        }
    }
}

