/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.jminix;

import de.chandre.admintool.core.controller.AbstractAdminController;
import de.chandre.admintool.jminix.AdminToolJminixConfig;
import de.chandre.admintool.jminix.AdminToolJmxService;
import de.chandre.admintool.jmx.jstree.JmxExecuteTO;
import de.chandre.admintool.jmx.jstree.JmxQueryTO;
import de.chandre.admintool.jmx.jstree.JmxResponseTO;
import de.chandre.admintool.jmx.jstree.JsTree;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/admintool/jmx"})
public class AdminToolJmxController
extends AbstractAdminController {
    private static final Log LOGGER = LogFactory.getLog(AdminToolJmxController.class);
    @Autowired
    private AdminToolJminixConfig config;
    @Autowired
    private AdminToolJmxService jmxService;

    @RequestMapping(value={"/tree"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<JsTree> getNode(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.config.isEnabled()) {
            LOGGER.debug((Object)"building JMX tree");
            try {
                return this.jmxService.buildTree();
            }
            catch (Exception e) {
                e.printStackTrace();
                response.sendError(500, e.getMessage());
            }
        }
        return null;
    }

    @RequestMapping(value={"/attributes", "/attribute"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public JmxResponseTO attributes(@RequestBody JmxQueryTO queryTO, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.config.isEnabled()) {
            LOGGER.debug((Object)("resolving attributes: " + queryTO));
            try {
                return this.jmxService.getAttributes(queryTO);
            }
            catch (Exception e) {
                e.printStackTrace();
                response.sendError(500, e.getMessage());
            }
        }
        return null;
    }

    @RequestMapping(value={"/operation"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public JmxResponseTO operations(@RequestBody JmxQueryTO queryTO, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.config.isEnabled()) {
            LOGGER.debug((Object)("resolving operations: " + queryTO));
            try {
                return this.jmxService.getOpperation(queryTO);
            }
            catch (Exception e) {
                e.printStackTrace();
                response.sendError(500, e.getMessage());
            }
        }
        return null;
    }

    @RequestMapping(value={"/operation/execute"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public JmxResponseTO updateValue(@RequestBody JmxExecuteTO executeTO, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.config.isEnabled()) {
            LOGGER.debug((Object)("update value: " + executeTO));
            try {
                return this.jmxService.getExecuteOperation(executeTO);
            }
            catch (Exception e) {
                e.printStackTrace();
                response.sendError(500, e.getMessage());
            }
        }
        return null;
    }
}

