/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.jminix;

import de.chandre.admintool.core.AbstractAdminToolLoader;
import de.chandre.admintool.core.AdminTool;
import de.chandre.admintool.core.component.AdminComponent;
import de.chandre.admintool.core.component.AdminComponentImpl;
import de.chandre.admintool.core.component.MenuEntry;
import de.chandre.admintool.jminix.AdminToolJminixConfig;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AdminToolJminixLoader
extends AbstractAdminToolLoader {
    private static final Log LOGGER = LogFactory.getLog(AdminToolJminixLoader.class);
    @Autowired
    private AdminTool adminTool;
    @Autowired
    private AdminToolJminixConfig config;

    @PostConstruct
    public void configureAdminTool() {
        if (!this.coreConfig.isEnabled() || !this.config.isEnabled()) {
            LOGGER.info((Object)"admin tool's jminix browser is deactivated");
            return;
        }
        LOGGER.info((Object)"adding JMX Console to admin tool");
        LOGGER.debug((Object)((Object)((Object)this)).toString());
        boolean relative = !this.shouldCDNsUsed();
        AdminComponentImpl component = new AdminComponentImpl();
        component.setPosition(this.config.getComponentPosition());
        component.getSecurityRoles().addAll(this.config.getSecurityRoles());
        component.setDisplayName("JMX Console");
        component.addAdditionalJS(this.getWebjarsBowerPrefixUri() + "mustache/" + this.config.getMustacheVersion() + "/mustache.min.js", relative);
        component.addAdditionalJS(this.getWebjarsBowerPrefixUri() + "jstree/" + this.config.getJsTreeVersion() + "/dist/jstree.js", relative);
        component.addAdditionalJS("/static/admintool/jmx/js/jquery-resizable.js", true);
        component.addAdditionalJS("/static/admintool/jmx/js/jmx.js", true);
        component.addAdditionalCSS(this.getWebjarsBowerPrefixUri() + "jstree/" + this.config.getJsTreeVersion() + "/dist/themes/default/style.css", relative);
        component.addAdditionalCSS("/static/admintool/jmx/css/jmx.css", true);
        component.setMainMenu(MenuEntry.builder().displayName("JMX").name("jmx").target("content/jmx/jmx").resouceMessageKeySuffix("jmx.displayName").build());
        this.adminTool.addComponent((AdminComponent)component);
    }
}

