/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.fileviewer;

import de.chandre.admintool.filebrowser.AbstractFileBrowserService;
import de.chandre.admintool.filebrowser.GenericFilebrowserException;
import de.chandre.admintool.fileviewer.AdminToolFileviewerConfig;
import de.chandre.admintool.fileviewer.AdminToolFileviewerService;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="adminToolFileviewerService")
public class AdminToolFileviewerServiceImpl
extends AbstractFileBrowserService
implements AdminToolFileviewerService {
    @Autowired
    private AdminToolFileviewerConfig config;

    @Override
    public void isFileAllowed(File file, boolean write) throws GenericFilebrowserException {
        try {
            if (!this.config.isEnabled() || !this.isAllowed(file, write, this.config.isReadOnly()) || !this.isExtensionAllowedAndReadable(file) || write && !this.isExtensionAllowedAndWriteable(file)) {
                throw new GenericFilebrowserException("insufficient file permissions");
            }
        }
        catch (IOException e) {
            throw new GenericFilebrowserException("Error while try to check file permission: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean isExtensionAllowedAndReadable(File file) {
        if (null == file || !this.config.isEnabled() || file.isDirectory() || !file.canRead()) {
            return false;
        }
        return this.config.getAllowedExtensions().contains(this.getExtension(file));
    }

    @Override
    public boolean isExtensionAllowedAndWriteable(File file) {
        if (!this.config.isReadOnly() && this.isExtensionAllowedAndReadable(file) && file.canWrite()) {
            return this.config.getAllowedExtensionsToEdit().contains(this.getExtension(file));
        }
        return false;
    }

    @Override
    public String readFileToString(File file, String encoding) throws IOException {
        return FileUtils.readFileToString((File)file, (String)(StringUtils.isEmpty((Object)encoding) ? this.config.getDefaultEncoding() : encoding));
    }

    @Override
    public boolean isChangeable(File file) {
        return this.isExtensionAllowedAndWriteable(file);
    }

    @Override
    public void writeStringToFile(File file, String encoding, String fileContent) throws GenericFilebrowserException {
        this.isFileAllowed(file, true);
        try {
            FileUtils.writeStringToFile((File)file, (String)fileContent, (String)encoding, (boolean)false);
        }
        catch (Exception e) {
            throw new GenericFilebrowserException("could not write content to file: " + e.getMessage(), e);
        }
    }
}

