/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.fileviewer;

import de.chandre.admintool.core.controller.AbstractAdminController;
import de.chandre.admintool.filebrowser.AdminToolFilebrowserConfig;
import de.chandre.admintool.filebrowser.AdminToolFilebrowserService;
import de.chandre.admintool.filebrowser.DownloadNotAllowedException;
import de.chandre.admintool.filebrowser.GenericFilebrowserException;
import de.chandre.admintool.fileviewer.AdminToolFileviewerConfig;
import de.chandre.admintool.fileviewer.AdminToolFileviewerService;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/admintool/fileviewer"})
public class AdminToolFileviewerController
extends AbstractAdminController {
    private static final Log LOGGER = LogFactory.getLog(AdminToolFileviewerController.class);
    @Autowired
    private AdminToolFileviewerService fileviewerService;
    @Autowired
    private AdminToolFilebrowserService filebrowserService;
    @Autowired
    private AdminToolFileviewerConfig fileviewerConfig;
    @Autowired
    private AdminToolFilebrowserConfig filebrowserConfig;

    @RequestMapping(value={"/show"}, method={RequestMethod.GET, RequestMethod.POST})
    public String loadFile(@RequestParam(value="file") String file, @RequestParam(name="encoding", required=false) String encoding, ModelMap model, HttpServletRequest request) throws GenericFilebrowserException, UnsupportedEncodingException {
        if (!this.fileviewerConfig.isEnabled()) {
            return null;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("serving file viewer page for file: " + file + ", encoding: " + encoding));
        }
        String templatePath = this.addCommonContextVars(model, request, "filebrowser", "filebrowser/content/fileviewer");
        String decodedPath = URLDecoder.decode(file, "UTF-8");
        File currentFile = new File(decodedPath);
        model.put((Object)"currentDir", (Object)currentFile.getParent());
        this.fileviewerService.isFileAllowed(currentFile, false);
        model.put((Object)"currentFile", (Object)currentFile);
        model.put((Object)"selEncoding", (Object)(StringUtils.isEmpty((Object)encoding) ? this.fileviewerConfig.getDefaultEncoding() : encoding));
        return "admintool/" + templatePath;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String updateFile(@RequestParam(value="file") String file, @RequestParam(name="encoding", required=false) String encoding, @RequestParam(value="fileContent") String fileContent, ModelMap model, HttpServletRequest request) throws GenericFilebrowserException {
        if (!this.fileviewerConfig.isEnabled()) {
            return null;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("updating file: " + file + ", encoding: " + encoding));
        }
        String templatePath = this.addCommonContextVars(model, request, "filebrowser", null);
        File currentFile = new File(file);
        model.put((Object)"currentDir", (Object)currentFile.getParent());
        this.fileviewerService.writeStringToFile(currentFile, encoding, fileContent);
        return "admintool/" + templatePath;
    }

    @ExceptionHandler(value={DownloadNotAllowedException.class, GenericFilebrowserException.class})
    public ModelAndView handleException(Exception exception, HttpServletRequest request) throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("handleException: " + exception.getMessage()));
        }
        ModelAndView mv = new ModelAndView("admintool/content/error");
        this.addCommonContextVars(mv.getModelMap(), request, "filebrowser", null);
        String lastFile = request.getParameter("file");
        if (StringUtils.isEmpty((Object)lastFile)) {
            lastFile = request.getParameter("selectedFile");
        }
        String decodedPath = null;
        if (StringUtils.hasLength((String)lastFile)) {
            decodedPath = URLDecoder.decode(lastFile, "UTF-8");
        }
        LOGGER.info((Object)("lastFile: " + lastFile));
        if (StringUtils.hasLength((String)decodedPath) && this.filebrowserService.isAllowed(new File(decodedPath).getParentFile(), false, this.filebrowserConfig.isReadOnly())) {
            mv.getModelMap().put((Object)"currentDir", (Object)new File(decodedPath).getParent());
        } else {
            mv.getModelMap().put((Object)"currentDir", (Object)this.filebrowserConfig.getStartDir().getAbsolutePath());
        }
        mv.getModelMap().put((Object)"exceptionMessage", (Object)exception.getMessage());
        return mv;
    }
}

