/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.fileviewer;

import de.chandre.admintool.core.AdminToolConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="adminToolFileviewerConfig")
public class AdminToolFileviewerConfig
implements AdminToolConfig {
    private static final Log LOGGER = LogFactory.getLog(AdminToolFileviewerConfig.class);
    @Value(value="${admintool.fileviewer.enabled:true}")
    private boolean enabled;
    @Value(value="#{'${admintool.fileviewer.encodings:UTF-8;ISO-8859-1}'.split(';')}")
    private List<String> encodings = new ArrayList<String>();
    @Value(value="${admintool.fileviewer.defaultEncoding:UTF-8}")
    private String defaultEncoding;
    @Value(value="${admintool.fileviewer.readOnly:true}")
    private boolean readOnly;
    @Value(value="#{'${admintool.fileviewer.allowedExtensions:txt;sql;properties;xml;xsd;wsdl;dtd;htm;html;css;js;ts;json;yml;yaml;log;md;sh;bat;cmd;php;php4;php5;py;lua;java;jsp;jspx;jspf;diff}'.split(';')}")
    private List<String> allowedExtensions = new ArrayList<String>();
    @Value(value="#{'${admintool.fileviewer.allowedExtensionsToEdit:txt;dtd;htm;html;css;js;ts;md}'.split(';')}")
    private List<String> allowedExtensionsToEdit = new ArrayList<String>();
    @Value(value="${admintool.fileviewer.codeMirrorVersion:5.27.4}")
    private String codeMirrorVersion;
    @Value(value="${admintool.fileviewer.codeMirror.cdn.useBower:true}")
    private boolean codeMirrorUseBowser;
    @Value(value="#{'${admintool.fileviewer.codeMirrorAddLibs:addon/edit/matchbrackets.js}'.split(';')}")
    private List<String> codeMirrorAddLibs = new ArrayList<String>();

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<String> getEncodings() {
        return this.encodings;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public List<String> getAllowedExtensions() {
        return Collections.unmodifiableList(this.allowedExtensions);
    }

    public List<String> getAllowedExtensionsToEdit() {
        return Collections.unmodifiableList(this.allowedExtensionsToEdit);
    }

    public String getCodeMirrorVersion() {
        return this.codeMirrorVersion;
    }

    public boolean getCodeMirrorUseBowser() {
        return this.codeMirrorUseBowser;
    }

    public List<String> getCodeMirrorAddLibs() {
        return this.codeMirrorAddLibs;
    }

    @PostConstruct
    public void printConfig() {
        LOGGER.debug((Object)this.toString());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AdminToolFileviewerConfig [enabled=").append(this.enabled).append(", encodings=").append(this.encodings).append(", defaultEncoding=").append(this.defaultEncoding).append(", readOnly=").append(this.readOnly).append(", allowedExtensions=").append(this.allowedExtensions).append(", codeMirrorVersion=").append(this.codeMirrorVersion).append(", codeMirrorUseBowser=").append(this.codeMirrorUseBowser).append(", codeMirrorAddLibs=").append(this.codeMirrorAddLibs).append("]");
        return builder.toString();
    }
}

