/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.filebrowser;

import de.chandre.admintool.core.utils.RegexUtil;
import de.chandre.admintool.filebrowser.AbstractFileBrowserService;
import de.chandre.admintool.filebrowser.AdminToolFilebrowserConfig;
import de.chandre.admintool.filebrowser.AdminToolFilebrowserService;
import de.chandre.admintool.filebrowser.DownloadNotAllowedException;
import de.chandre.admintool.filebrowser.GenericFilebrowserException;
import de.chandre.admintool.filebrowser.MimeTypes;
import de.chandre.admintool.filebrowser.SortColumn;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service(value="adminToolFilebrowserService")
public class AdminToolFilebrowserServiceImpl
extends AbstractFileBrowserService
implements AdminToolFilebrowserService {
    private static final Log LOGGER = LogFactory.getLog(AdminToolFilebrowserServiceImpl.class);
    private static final Map<Integer, String> FILE_SIZE_EXP = new TreeMap<Integer, String>();
    @Autowired
    private AdminToolFilebrowserConfig config;
    @Autowired
    private Environment env;
    private Set<String> rootDirsCache = Collections.newSetFromMap(new ConcurrentHashMap());

    @Override
    public Set<String> getRootDirs() {
        File[] roots = File.listRoots();
        if (this.rootDirsCache.isEmpty()) {
            for (File file : roots) {
                if (this.config.getForbiddenDrives().contains(file.getAbsolutePath().toLowerCase())) continue;
                this.rootDirsCache.add(file.getAbsolutePath());
            }
        }
        return this.rootDirsCache;
    }

    @Override
    public boolean isRootActive(String rootDir, String currentDir) {
        return !StringUtils.isEmpty((Object)currentDir) && currentDir.toLowerCase().startsWith(rootDir.toLowerCase());
    }

    @Override
    public String getParent(String dir) throws IOException {
        File file = new File(dir);
        if (null != file.getParent() && this.isAllowed(file.getParentFile(), false)) {
            return file.getParent();
        }
        return "";
    }

    protected List<File> sort(File[] fileAr, final SortColumn sortCol, Boolean sortAsc) {
        List<File> files = Arrays.asList(fileAr);
        if (null == sortCol) {
            return files;
        }
        if (null == sortAsc) {
            sortAsc = Boolean.TRUE;
        }
        final int direction = sortAsc != false ? 1 : -1;
        Collections.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                try {
                    switch (sortCol) {
                        case DATE: {
                            return AdminToolFilebrowserServiceImpl.this.getLastChange(o1).compareTo(AdminToolFilebrowserServiceImpl.this.getLastChange(o2)) * direction;
                        }
                        case SIZE: {
                            return Long.valueOf(o1.length()).compareTo(o2.length()) * direction;
                        }
                        case TYPE: {
                            return AdminToolFilebrowserServiceImpl.this.getFileType(o1).compareTo(AdminToolFilebrowserServiceImpl.this.getFileType(o2)) * direction;
                        }
                    }
                    return o1.getName().compareTo(o2.getName()) * direction;
                }
                catch (Exception exception) {
                    return 0;
                }
            }
        });
        return files;
    }

    @Override
    public String getSortDirection(int current, SortColumn sortCol, Boolean sortAsc) {
        if (current == sortCol.getIndex() && sortAsc != null) {
            return sortAsc != false ? "up" : "down";
        }
        return "";
    }

    @Override
    public List<File> getDirectories(String currentDir, SortColumn sortCol, Boolean sortAsc, String filter) throws IOException {
        Pattern fileNamePattern;
        File[] files;
        File file = new File(currentDir);
        if (null != file && this.isAllowed(file, false) && (files = file.listFiles(new FileFilter(fileNamePattern = this.getFileNamePattern(filter)){
            final /* synthetic */ Pattern val$fileNamePattern;
            {
                this.val$fileNamePattern = pattern;
            }

            @Override
            public boolean accept(File dir) {
                try {
                    if (AdminToolFilebrowserServiceImpl.this.isAllowed(dir, false) && dir.isDirectory()) {
                        if (null == this.val$fileNamePattern) {
                            return true;
                        }
                        if (null != this.val$fileNamePattern && this.val$fileNamePattern.matcher(dir.getName()).matches()) {
                            return true;
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.debug((Object)e.getMessage(), (Throwable)e);
                }
                return false;
            }
        })) != null) {
            return this.sort(files, sortCol, sortAsc);
        }
        return Collections.emptyList();
    }

    @Override
    public List<File> getFiles(String currentDir, SortColumn sortCol, Boolean sortAsc, String filter) throws IOException {
        Pattern fileNamePattern;
        File[] files;
        File file = new File(currentDir);
        if (null != file && this.isAllowed(file, false) && (files = file.listFiles(new FileFilter(fileNamePattern = this.getFileNamePattern(filter)){
            final /* synthetic */ Pattern val$fileNamePattern;
            {
                this.val$fileNamePattern = pattern;
            }

            @Override
            public boolean accept(File dir) {
                try {
                    if (AdminToolFilebrowserServiceImpl.this.isAllowed(dir, false) && dir.isFile()) {
                        if (null == this.val$fileNamePattern) {
                            return true;
                        }
                        if (null != this.val$fileNamePattern && this.val$fileNamePattern.matcher(dir.getName()).matches()) {
                            return true;
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.debug((Object)e.getMessage(), (Throwable)e);
                }
                return false;
            }
        })) != null) {
            return this.sort(files, sortCol, sortAsc);
        }
        return Collections.emptyList();
    }

    private Pattern getFileNamePattern(String filter) {
        if (!StringUtils.isEmpty((Object)filter)) {
            return Pattern.compile(RegexUtil.wildcardToRegex((String)filter), 2);
        }
        return null;
    }

    @Override
    public String getDirOrRootName(File currentDir) {
        if (StringUtils.isEmpty((Object)currentDir.getName())) {
            return currentDir.getAbsolutePath();
        }
        return currentDir.getName();
    }

    @Override
    public List<File> getBreadcrumb(String currentDir) {
        if (null == currentDir) {
            return Collections.emptyList();
        }
        ArrayList<File> result = new ArrayList<File>();
        File file = new File(currentDir);
        this.getParentsRecursive(file, result);
        return result;
    }

    private void getParentsRecursive(File actual, List<File> files) {
        if (null != actual.getParentFile()) {
            this.getParentsRecursive(actual.getParentFile(), files);
        }
        if (actual.isDirectory()) {
            files.add(actual);
        }
    }

    @Override
    public String getFileSizeSum(String dir, String filter) throws IOException {
        List<File> files = this.getFiles(dir, null, true, filter);
        Long res = files.stream().collect(Collectors.summingLong(File::length));
        return String.format("%s in %s files", this.getFileSize(res), files.size());
    }

    @Override
    public Date getLastChange(File file) throws IOException {
        if (null != file) {
            FileTime time = Files.getLastModifiedTime(file.toPath(), new LinkOption[0]);
            return new Date(time.toMillis());
        }
        return new Date();
    }

    @Override
    public String getFileType(File file) {
        if (null == file) {
            return "";
        }
        if (file.isDirectory()) {
            return "DIR";
        }
        if (file.getName().lastIndexOf(46) == -1) {
            return "";
        }
        return this.getExtension(file);
    }

    @Override
    public String getFileSize(File file) {
        return this.getFileSize(file.length());
    }

    @Override
    public String getFileSize(long fileLength) {
        return this.calculateDisplayFileSize(fileLength, this.config.getSizeDivisorMultiplicator());
    }

    @Override
    public String getNormalFileSize(long fileLength) {
        return this.calculateDisplayFileSize(fileLength, 1024L);
    }

    protected String calculateDisplayFileSize(long fileLength, long sizeDivisorMultiplicator) {
        BigInteger multiplicator = BigInteger.valueOf(sizeDivisorMultiplicator);
        BigInteger size = BigInteger.valueOf(fileLength);
        for (Map.Entry<Integer, String> entry : FILE_SIZE_EXP.entrySet()) {
            BigInteger divisor = multiplicator.pow(entry.getKey());
            if (fileLength >= divisor.longValue()) continue;
            if (entry.getKey() == 1) {
                return String.valueOf(size) + entry.getValue();
            }
            return this.formatFileSize(size, multiplicator.pow(entry.getKey() - 1), entry.getValue());
        }
        return FileUtils.byteCountToDisplaySize((long)fileLength);
    }

    protected String formatFileSize(BigInteger fileLength, BigInteger divisor, String unit) {
        BigDecimal size = new BigDecimal(fileLength);
        size = size.setScale(this.config.getFileSizeDisplayScale()).divide(new BigDecimal(divisor), 6);
        return String.format("%s %s", size.doubleValue(), unit);
    }

    protected void prepareDownloadResponse(String fileName, Long size, HttpServletResponse response, boolean asAttachment) {
        String mimeType = MimeTypes.getMimeType(this.getExtension(fileName));
        LOGGER.info((Object)("following mimeType:" + mimeType));
        if (asAttachment || null == mimeType) {
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename=\"" + fileName + "\"");
        } else {
            response.setContentType(mimeType);
            response.setHeader("Content-Disposition", "inline;filename=\"" + fileName + "\"");
        }
        if (null != size) {
            response.setContentLength(size.intValue());
        }
    }

    @Override
    public void downloadFile(String filePath, HttpServletResponse response, boolean asAttachment) throws DownloadNotAllowedException, GenericFilebrowserException {
        this.downloadFile(filePath, response, null, asAttachment);
    }

    @Override
    public void downloadFile(String filePath, HttpServletResponse response, String alternativeFileName, boolean asAttachment) throws DownloadNotAllowedException, GenericFilebrowserException {
        File file = new File(filePath);
        try {
            if (!this.isAllowed(file, false)) {
                throw new DownloadNotAllowedException();
            }
        }
        catch (IOException e) {
            throw new GenericFilebrowserException(e);
        }
        this.prepareDownloadResponse(StringUtils.isEmpty((Object)alternativeFileName) ? file.getName() : alternativeFileName, file.length(), response, asAttachment);
        FileInputStream in = null;
        BufferedInputStream fileInput = null;
        try {
            in = new FileInputStream(file);
            fileInput = new BufferedInputStream(in);
            ServletOutputStream out = response.getOutputStream();
            IOUtils.copy((InputStream)fileInput, (OutputStream)out, (int)8192);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new GenericFilebrowserException("could not prepare file for downloading", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInput);
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fileInput);
        IOUtils.closeQuietly((InputStream)in);
    }

    @Override
    public void downloadFilesAsZip(List<String> filePaths, HttpServletResponse response) throws GenericFilebrowserException {
        File tempFile = null;
        try {
            Object out = null;
            try {
                if (this.config.isZipUseTempFile()) {
                    String tempDirConf = this.config.getZipTempDir();
                    Object tempDir = null;
                    if (StringUtils.isEmpty((Object)tempDirConf)) {
                        tempFile = File.createTempFile("zip", null);
                    } else {
                        tempDir = tempDirConf.startsWith("sys") ? new File(System.getProperty(tempDirConf.substring(4, tempDirConf.length()))) : (tempDirConf.startsWith("env") ? new File(this.env.getProperty(tempDirConf.substring(4, tempDirConf.length()))) : new File(tempDirConf));
                    }
                    if (null == tempFile) {
                        tempFile = File.createTempFile("zip", null, tempDir);
                    }
                    out = new FileOutputStream(tempFile);
                }
            }
            catch (Exception e) {
                LOGGER.warn((Object)"could not create temporary file, using servlet outputstream for serving ZIP");
            }
            if (null == out) {
                tempFile = null;
                this.prepareDownloadResponse("rename_me.zip", null, response, true);
                out = response.getOutputStream();
            }
            final ZipOutputStream zos = new ZipOutputStream((OutputStream)out);
            zos.setLevel(this.config.getZipCompessionLevel());
            try {
                for (String filePathStr : filePaths) {
                    final File orgfile = new File(filePathStr);
                    Files.walkFileTree(orgfile.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            if (!AdminToolFilebrowserServiceImpl.this.isAllowed(file.toFile(), false)) {
                                LOGGER.debug((Object)("ZIP creation: skipping not allowed file: " + file.toAbsolutePath()));
                                return FileVisitResult.CONTINUE;
                            }
                            String entry = orgfile.getParentFile().toPath().relativize(file).toString();
                            LOGGER.trace((Object)("creating entry: " + entry));
                            zos.putNextEntry(new ZipEntry(entry));
                            Files.copy(file, zos);
                            zos.closeEntry();
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                            if (!AdminToolFilebrowserServiceImpl.this.isAllowed(dir.toFile(), false)) {
                                LOGGER.debug((Object)("ZIP creation: skipping not allowed directory and subtree for: " + dir.toAbsolutePath()));
                                return FileVisitResult.SKIP_SUBTREE;
                            }
                            String entry = orgfile.getParentFile().toPath().relativize(dir).toString() + "/";
                            LOGGER.trace((Object)("creating dir: " + entry));
                            zos.putNextEntry(new ZipEntry(entry));
                            zos.closeEntry();
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                zos.finish();
            }
            catch (IOException e) {
                IOUtils.closeQuietly((OutputStream)zos);
                throw new GenericFilebrowserException("Could not create zip file is allowed ", e);
            }
            ((OutputStream)out).flush();
            if (null != tempFile && this.config.isZipUseTempFile()) {
                IOUtils.closeQuietly((OutputStream)out);
                this.downloadFile(tempFile.getAbsolutePath(), response, "rename_me.zip", true);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new GenericFilebrowserException(e);
        }
        finally {
            if (null != tempFile && this.config.isZipUseTempFile()) {
                try {
                    if (!tempFile.delete()) {
                        tempFile.deleteOnExit();
                    }
                }
                catch (Exception e2) {
                    LOGGER.warn((Object)("could not delete tempfile " + tempFile.getAbsolutePath()));
                    tempFile.deleteOnExit();
                }
            }
        }
    }

    protected boolean isAllowed(File path, boolean write) throws IOException {
        return this.isAllowed(path, write, this.config.isReadOnly());
    }

    @Override
    public String accessibleCSS(File file) {
        String res = "";
        if (!file.canRead()) {
            res = res + "not-readable";
        }
        if (!file.canWrite()) {
            res = res + " not-writeable";
        }
        if (file.isHidden()) {
            res = res + " file-hidden";
        }
        return res.trim();
    }

    @Override
    public String createFolder(String path, String folderName) throws IOException, GenericFilebrowserException {
        if (StringUtils.isEmpty((Object)path) && StringUtils.isEmpty((Object)folderName)) {
            throw new GenericFilebrowserException("Nothing to create.");
        }
        File file = new File(path);
        if (file.exists()) {
            if (this.isAllowed(file, true)) {
                if ((file = new File(file, folderName)).mkdirs()) {
                    return file.getAbsolutePath();
                }
                throw new GenericFilebrowserException("Could not create directories.");
            }
        } else {
            LOGGER.warn((Object)("[createFolder] folder already exists: " + path));
        }
        return null;
    }

    @Override
    public String deleteResource(String path) throws IOException, GenericFilebrowserException {
        if (StringUtils.isEmpty((Object)path)) {
            throw new GenericFilebrowserException("Nothing to delete.");
        }
        File file = new File(path);
        if (file.isDirectory() && !this.config.isDelteFolderAllowed()) {
            throw new GenericFilebrowserException("Delete folders functionality is deactivated.");
        }
        if (file.isFile() && !this.config.isDelteFileAllowed()) {
            throw new GenericFilebrowserException("Delete files functionality is deactivated.");
        }
        if (!this.isAllowed(file, true)) {
            throw new GenericFilebrowserException("Delete " + (file.isDirectory() ? "folder" : "file") + " is not allowed.");
        }
        if (!file.canWrite() && this.config.isNotDeletableIfNotWriteable()) {
            throw new GenericFilebrowserException("Deleting " + (file.isDirectory() ? "folder" : "file") + " '" + file.getName() + "' is not allowed.");
        }
        String parent = file.getParent();
        if (file.isFile()) {
            FileUtils.deleteQuietly((File)file);
        } else {
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (Exception e) {
                LOGGER.error((Object)"error deleting folder", (Throwable)e);
            }
        }
        return parent;
    }

    @Override
    public Map<String, Object> getFileInfo(String path) throws IOException {
        File file = new File(path);
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        result.put("file", file);
        if (file.isFile() && file.canRead() && this.config.getMaxFilesizeForHashes() > file.length()) {
            if (this.config.isInfoCrc32()) {
                result.put("file.checksumCRC32", FileUtils.checksumCRC32((File)file));
            }
            FileInputStream fis = new FileInputStream(file);
            if (this.config.isInfoMD5()) {
                result.put("file.md5Hex", DigestUtils.md5Hex((InputStream)fis));
            }
            if (this.config.isInfoSha1()) {
                result.put("file.sha1Hex", DigestUtils.sha1Hex((InputStream)fis));
            }
            if (this.config.isInfoSha256()) {
                result.put("file.sha256Hex", DigestUtils.sha256Hex((InputStream)fis));
            }
            IOUtils.closeQuietly((InputStream)fis);
        }
        result.put("file.lastModified", file.lastModified());
        result.put("file.canWrite", file.canWrite());
        result.put("file.canRead", file.canRead());
        result.put("file.canExecute", file.canExecute());
        result.put("file.isHidden", file.isHidden());
        result.put("disk.totalSpace", file.getTotalSpace());
        result.put("disk.usableSpace", file.getUsableSpace());
        result.put("disk.freeSpace", file.getFreeSpace());
        result.put("disk.totalSpace.coreFormat", this.getFileSize(file.getTotalSpace()));
        result.put("disk.usableSpace.coreFormat", this.getFileSize(file.getUsableSpace()));
        result.put("disk.freeSpace.coreFormat", this.getFileSize(file.getFreeSpace()));
        result.put("disk.totalSpace.commonFormat", this.getNormalFileSize(file.getTotalSpace()));
        result.put("disk.usableSpace.commonFormat", this.getNormalFileSize(file.getUsableSpace()));
        result.put("disk.freeSpace.commonFormat", this.getNormalFileSize(file.getFreeSpace()));
        String os = System.getProperty("os.name").toLowerCase();
        result.put("system.operationSystem", os);
        Class attributesClass = AdminToolFilebrowserServiceImpl.isWindows(os) ? DosFileAttributes.class : BasicFileAttributes.class;
        DosFileAttributes attr = Files.readAttributes(file.toPath(), attributesClass, new LinkOption[0]);
        result.put("file.attr.creationTime", attr.creationTime());
        result.put("file.attr.lastAccessTime", attr.lastAccessTime());
        result.put("file.attr.lastModifiedTime", attr.lastModifiedTime());
        result.put("file.attr.isDirectory", attr.isDirectory());
        result.put("file.attr.isOther", attr.isOther());
        result.put("file.attr.isRegularFile", attr.isRegularFile());
        result.put("file.attr.isSymbolicLink", attr.isSymbolicLink());
        result.put("file.attr.size", attr.size());
        if (DosFileAttributes.class.isAssignableFrom(attr.getClass())) {
            result.put("file.attr.isArchive", attr.isArchive());
            result.put("file.attr.isHidden", attr.isHidden());
            result.put("file.attr.isReadOnly", attr.isReadOnly());
            result.put("file.attr.isSystem", attr.isSystem());
        }
        long size = file.length();
        if (file.isDirectory() && !attr.isSymbolicLink() && this.config.isCountFolderSize()) {
            size = FileUtils.sizeOfDirectory((File)file);
        }
        result.put("file.size", size);
        result.put("file.size.coreFormat", this.getFileSize(size));
        result.put("file.size.commonFormat", this.getNormalFileSize(size));
        if (!AdminToolFilebrowserServiceImpl.isWindows(os)) {
            Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(file.toPath(), LinkOption.NOFOLLOW_LINKS);
            result.put("file.permissions", PosixFilePermissions.toString(permissions));
        }
        return result;
    }

    public static boolean isWindows(String os) {
        return os.indexOf("win") >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveFile(String decodedPath, MultipartFile upload) throws IOException, GenericFilebrowserException {
        block5: {
            if (StringUtils.isEmpty((Object)decodedPath)) {
                return false;
            }
            File uploadFolder = new File(decodedPath);
            if (!uploadFolder.isDirectory() || !this.isAllowed(uploadFolder, true)) break block5;
            FileOutputStream fos = null;
            try {
                File file = new File(uploadFolder, upload.getOriginalFilename());
                fos = new FileOutputStream(file);
                long result = IOUtils.copyLarge((InputStream)upload.getInputStream(), (OutputStream)fos);
                LOGGER.info((Object)String.format("uploaded %s bytes (%s)", result, this.getNormalFileSize(result)));
            }
            catch (Exception e) {
                boolean bl;
                try {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    bl = false;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fos);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)fos);
                return bl;
            }
            IOUtils.closeQuietly((OutputStream)fos);
            return true;
        }
        throw new GenericFilebrowserException("upload not allowed");
    }

    static {
        FILE_SIZE_EXP.put(1, " B");
        FILE_SIZE_EXP.put(2, " KB");
        FILE_SIZE_EXP.put(3, " MB");
        FILE_SIZE_EXP.put(4, " GB");
        FILE_SIZE_EXP.put(5, " TB");
        FILE_SIZE_EXP.put(6, " PB");
        FILE_SIZE_EXP.put(7, " EB");
    }
}

