/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.filebrowser;

import de.chandre.admintool.core.AbstractAdminToolLoader;
import de.chandre.admintool.core.AdminTool;
import de.chandre.admintool.core.component.AdminComponent;
import de.chandre.admintool.core.component.AdminComponentImpl;
import de.chandre.admintool.core.component.MenuEntry;
import de.chandre.admintool.filebrowser.AdminToolFilebrowserConfig;
import de.chandre.admintool.fileviewer.AdminToolFileviewerConfig;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AdminToolFilebrowserLoader
extends AbstractAdminToolLoader {
    private static final Log LOGGER = LogFactory.getLog(AdminToolFilebrowserLoader.class);
    public static final String TARGET_FILEBROWSER = "filebrowser/content/filebrowser";
    public static final String TARGET_FILEVIEWER = "filebrowser/content/fileviewer";
    @Autowired
    private AdminToolFilebrowserConfig filebrowserConfig;
    @Autowired
    private AdminToolFileviewerConfig fileviewerConfig;
    @Autowired
    private AdminTool adminTool;

    @PostConstruct
    public void configureAdminTool() {
        if (!this.coreConfig.isEnabled() || !this.filebrowserConfig.isEnabled()) {
            LOGGER.info((Object)"admin tool's filebrowser is deactivated");
            return;
        }
        LOGGER.info((Object)"adding Filebrowser view to admin tool");
        AdminComponentImpl component = new AdminComponentImpl();
        component.setPosition(this.filebrowserConfig.getComponentPosition());
        component.setDisplayName("Filebrowser");
        component.getSecurityRoles().addAll(this.filebrowserConfig.getSecurityRoles());
        component.addAdditionalCSS("/static/admintool/filebrowser/fine-uploader/5.15.0/fine-uploader-gallery.min.css", true);
        component.addAdditionalJS("/static/admintool/filebrowser/fine-uploader/5.15.0/fine-uploader.min.js", true);
        component.addAdditionalJS("/static/admintool/filebrowser/js/filebrowser.js", true);
        if (this.fileviewerConfig.isEnabled()) {
            boolean relative = !this.shouldCDNsUsed();
            component.addAdditionalJS("/static/admintool/filebrowser/js/fileviewer.js", true);
            String codeMirrorPrefix = this.getWebjarsPrefixUri(this.fileviewerConfig.getCodeMirrorUseBowser()) + "codemirror/" + this.fileviewerConfig.getCodeMirrorVersion() + "/";
            component.addAdditionalJS(codeMirrorPrefix + "lib/codemirror.js", relative);
            component.addAdditionalJS(codeMirrorPrefix + "mode/meta.js", relative);
            if (null != this.fileviewerConfig.getCodeMirrorAddLibs()) {
                this.fileviewerConfig.getCodeMirrorAddLibs().forEach(arg_0 -> AdminToolFilebrowserLoader.lambda$configureAdminTool$0((AdminComponent)component, codeMirrorPrefix, relative, arg_0));
            }
            component.addAdditionalJS(codeMirrorPrefix + "addon/mode/loadmode.js", relative);
            component.addAdditionalJS(codeMirrorPrefix + "addon/hint/show-hint.js", relative);
            component.addAdditionalCSS(codeMirrorPrefix + "lib/codemirror.css", relative);
            component.addAdditionalCSS(codeMirrorPrefix + "addon/hint/show-hint.css", relative);
            component.addAdditionalCSS("/static/admintool/filebrowser/css/fileviewer.css", true);
        }
        MenuEntry mainMenu = new MenuEntry();
        mainMenu.setDisplayName("Filebrowser");
        mainMenu.setName("filebrowser");
        mainMenu.setTarget(TARGET_FILEBROWSER);
        mainMenu.setHide(this.filebrowserConfig.isHideMenuItem());
        mainMenu.addAdditionalCSS("/static/admintool/filebrowser/css/filebrowser.css", true);
        mainMenu.setResouceMessageKey("ui.admintool.core.filebrowser.displayName");
        component.setMainMenu(mainMenu);
        this.adminTool.addComponent((AdminComponent)component);
    }

    private static /* synthetic */ void lambda$configureAdminTool$0(AdminComponent component, String codeMirrorPrefix, boolean relative, String libpath) {
        component.addAdditionalJS(codeMirrorPrefix + libpath, relative);
    }
}

