/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.filebrowser;

import de.chandre.admintool.core.controller.AbstractAdminController;
import de.chandre.admintool.filebrowser.AdminToolFilebrowserConfig;
import de.chandre.admintool.filebrowser.AdminToolFilebrowserService;
import de.chandre.admintool.filebrowser.DownloadNotAllowedException;
import de.chandre.admintool.filebrowser.FileUploadResponse;
import de.chandre.admintool.filebrowser.GenericFilebrowserException;
import de.chandre.admintool.filebrowser.SortColumn;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/admintool/filebrowser"})
public class AdminToolFilebrowserController
extends AbstractAdminController {
    private static final Log LOGGER = LogFactory.getLog(AdminToolFilebrowserController.class);
    @Autowired
    private AdminToolFilebrowserService filebrowserService;
    @Autowired
    private AdminToolFilebrowserConfig filebrowserConfig;

    @RequestMapping(value={"", "/", "/dir"}, method={RequestMethod.GET, RequestMethod.POST})
    public String showDirectory(@RequestParam(name="dir", required=false) String dirPath, @RequestParam(name="sortCol", required=false) String sortCol, @RequestParam(name="sortAsc", required=false, defaultValue="true") boolean sortType, @RequestParam(name="filter", required=false) String filter, ModelMap model, HttpServletRequest request) throws UnsupportedEncodingException {
        String currentDir;
        if (!this.filebrowserConfig.isEnabled()) {
            return null;
        }
        String string = currentDir = StringUtils.isEmpty((Object)dirPath) ? this.filebrowserConfig.getStartDir().getAbsolutePath() : URLDecoder.decode(dirPath, "UTF-8");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("show directory: " + currentDir));
        }
        String templatePath = this.addCommonContextVars(model, request, "filebrowser", null);
        model.put((Object)"currentDir", (Object)currentDir);
        model.put((Object)"sortCol", (Object)SortColumn.fromIndex(sortCol));
        model.put((Object)"sortAsc", (Object)sortType);
        model.put((Object)"filter", (Object)filter);
        return "admintool/" + templatePath;
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.GET, RequestMethod.POST})
    public String info(@RequestParam(value="file") String filePath, ModelMap model, HttpServletRequest request, HttpServletResponse response) throws IOException, DownloadNotAllowedException, GenericFilebrowserException {
        if (!this.filebrowserConfig.isEnabled()) {
            return null;
        }
        String decodedPath = URLDecoder.decode(filePath, "UTF-8");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("info: " + decodedPath));
        }
        this.addCommonContextVars(model, request);
        model.addAttribute("infos", this.filebrowserService.getFileInfo(decodedPath));
        return "admintool/filebrowser/includes/fileInfo.inc";
    }

    @RequestMapping(value={"/file"}, method={RequestMethod.GET, RequestMethod.POST})
    public void showFile(@RequestParam(value="file") String filePath, ModelMap model, HttpServletRequest request, HttpServletResponse response) throws IOException, DownloadNotAllowedException, GenericFilebrowserException {
        if (!this.filebrowserConfig.isEnabled()) {
            return;
        }
        if (!this.filebrowserConfig.isDownloadAllowed()) {
            throw new DownloadNotAllowedException("file download is deactivated by configuration");
        }
        String decodedPath = URLDecoder.decode(filePath, "UTF-8");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("download file: " + decodedPath));
        }
        this.filebrowserService.downloadFile(decodedPath, response, false);
    }

    @RequestMapping(value={"/download"}, method={RequestMethod.GET, RequestMethod.POST})
    public void download(@RequestParam(value="file") String filePath, ModelMap model, HttpServletRequest request, HttpServletResponse response) throws IOException, DownloadNotAllowedException, GenericFilebrowserException {
        if (!this.filebrowserConfig.isEnabled()) {
            return;
        }
        if (!this.filebrowserConfig.isDownloadAllowed()) {
            throw new DownloadNotAllowedException("file download is deactivated by configuration");
        }
        String decodedPath = URLDecoder.decode(filePath, "UTF-8");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("download file: " + decodedPath));
        }
        this.filebrowserService.downloadFile(decodedPath, response, true);
    }

    @RequestMapping(value={"/zip"}, method={RequestMethod.GET, RequestMethod.POST})
    public void downloadAsZip(@RequestParam(value="selectedFile") List<String> filePaths, ModelMap model, HttpServletRequest request, HttpServletResponse response) throws IOException, DownloadNotAllowedException, GenericFilebrowserException {
        if (!this.filebrowserConfig.isEnabled()) {
            return;
        }
        if (!this.filebrowserConfig.isDownloadCompressedAllowed()) {
            throw new DownloadNotAllowedException("compressed file download is deactivated by configuration");
        }
        ArrayList<String> decodedPaths = new ArrayList<String>();
        if (null != filePaths) {
            filePaths.forEach(filePath -> {
                try {
                    decodedPaths.add(URLDecoder.decode(filePath, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            });
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("downloadAsZip file: " + decodedPaths.size()));
        }
        this.filebrowserService.downloadFilesAsZip(decodedPaths, response);
    }

    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    @ResponseBody
    public FileUploadResponse upload(@RequestParam(value="qqfile") MultipartFile qqfile, @RequestParam(value="qqfilename") String qqfilename, @RequestParam(value="qquuid") String qquuid, @RequestParam(value="currentDir") String currentDir, HttpServletRequest request, HttpServletResponse response) throws IOException, GenericFilebrowserException {
        if (!this.filebrowserConfig.isEnabled()) {
            return null;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("upload file: " + qqfilename));
        }
        FileUploadResponse fur = new FileUploadResponse();
        if (!this.filebrowserConfig.isUploadAllowed()) {
            fur.setError("file upload is not allowed");
            return fur;
        }
        String decodedPath = URLDecoder.decode(currentDir, "UTF-8");
        try {
            fur.setSuccess(this.filebrowserService.saveFile(decodedPath, qqfile));
            if (!fur.isSuccess()) {
                fur.setError("unable to opload file");
            }
        }
        catch (Exception e) {
            fur.setError(e.getMessage());
        }
        return fur;
    }

    @RequestMapping(value={"/createFolder"}, method={RequestMethod.POST})
    public String createFolder(@RequestParam(value="folderName") String folderPath, @RequestParam(value="currentDir") String currentDir, ModelMap model, HttpServletRequest request, HttpServletResponse response) throws IOException, GenericFilebrowserException {
        if (!this.filebrowserConfig.isEnabled()) {
            return null;
        }
        if (!this.filebrowserConfig.isCreateFolderAllowed()) {
            throw new GenericFilebrowserException("folder creation not allowed");
        }
        String decodedPath = URLDecoder.decode(currentDir, "UTF-8");
        String decodedFolder = URLDecoder.decode(folderPath, "UTF-8");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("create folder: " + decodedFolder + " in path: " + decodedPath));
        }
        String path = null;
        try {
            path = this.filebrowserService.createFolder(decodedPath, decodedFolder);
        }
        catch (GenericFilebrowserException e) {
            String templatePath = this.addCommonContextVars(model, request, "filebrowser", null);
            model.put((Object)"exceptionMessage", (Object)e.getMessage());
            model.put((Object)"currentDir", (Object)decodedPath);
            return "admintool/" + templatePath;
        }
        path = null != path ? URLEncoder.encode(path, "UTF-8") : folderPath;
        response.sendRedirect(this.getRootContext(request) + "/filebrowser?dir=" + path);
        return null;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public String deleteResource(@RequestParam(name="file", required=false) String filePath, ModelMap model, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.filebrowserConfig.isEnabled()) {
            return null;
        }
        String decodedPath = URLDecoder.decode(filePath, "UTF-8");
        LOGGER.info((Object)("delete resource: " + decodedPath));
        String path = null;
        try {
            path = this.filebrowserService.deleteResource(decodedPath);
        }
        catch (GenericFilebrowserException e) {
            String templatePath = this.addCommonContextVars(model, request, "filebrowser", null);
            model.put((Object)"exceptionMessage", (Object)e.getMessage());
            File currentPath = StringUtils.isEmpty((Object)decodedPath) ? this.filebrowserConfig.getStartDir() : new File(decodedPath);
            model.put((Object)"currentDir", currentPath.isDirectory() ? currentPath : currentPath.getParent());
            return "admintool/" + templatePath;
        }
        path = null != path ? URLEncoder.encode(path, "UTF-8") : filePath;
        response.sendRedirect(this.getRootContext(request) + "/filebrowser?dir=" + path);
        return null;
    }

    @ExceptionHandler(value={DownloadNotAllowedException.class, GenericFilebrowserException.class})
    public ModelAndView handleException(Exception exception, HttpServletRequest request) throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("handleException: " + exception.getMessage()));
        }
        ModelAndView mv = new ModelAndView("admintool/content/error");
        this.addCommonContextVars(mv.getModelMap(), request, "filebrowser", null);
        String lastFile = request.getParameter("file");
        if (StringUtils.isEmpty((Object)lastFile)) {
            lastFile = request.getParameter("selectedFile");
        }
        String decodedPath = null;
        if (StringUtils.hasLength((String)lastFile)) {
            decodedPath = URLDecoder.decode(lastFile, "UTF-8");
        }
        LOGGER.info((Object)("lastFile: " + lastFile));
        if (StringUtils.hasLength((String)decodedPath) && this.filebrowserService.isAllowed(new File(decodedPath).getParentFile(), false, this.filebrowserConfig.isReadOnly())) {
            mv.getModelMap().put((Object)"currentDir", (Object)new File(decodedPath).getParent());
        } else {
            mv.getModelMap().put((Object)"currentDir", (Object)this.filebrowserConfig.getStartDir().getAbsolutePath());
        }
        mv.getModelMap().put((Object)"exceptionMessage", (Object)exception.getMessage());
        return mv;
    }
}

