/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.filebrowser;

import de.chandre.admintool.core.AdminToolConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="adminToolFilebrowserConfig")
public class AdminToolFilebrowserConfig
implements AdminToolConfig {
    private static final Log LOGGER = LogFactory.getLog(AdminToolFilebrowserConfig.class);
    @Value(value="${admintool.filebrowser.enabled:true}")
    private boolean enabled;
    @Value(value="${admintool.filebrowser.hideMenuItem:false}")
    private boolean hideMenuItem;
    @Value(value="${admintool.filebrowser.startDir:}")
    private String startDir;
    @Value(value="#{'${admintool.filebrowser.forbiddenDrives:}'.split(';')}")
    private List<String> forbiddenDrives = new ArrayList<String>();
    @Value(value="${admintool.filebrowser.readOnly:false}")
    private boolean readOnly;
    @Value(value="${admintool.filebrowser.restrictedBrowsing:false}")
    private boolean restrictedBrowsing;
    @Value(value="${admintool.filebrowser.restrictedBrowsingIsWhitelist:true}")
    private boolean restrictedBrowsingIsWhitelist;
    @Value(value="#{'${admintool.filebrowser.restrictedPaths:}'.split(';')}")
    private List<String> restrictedPaths = new ArrayList<String>();
    @Value(value="${admintool.filebrowser.sizeDivisorMultiplicator:1000}")
    private long sizeDivisorMultiplicator;
    @Value(value="${admintool.filebrowser.fileSizeDisplayScale:2}")
    private byte fileSizeDisplayScale;
    @Value(value="${admintool.filebrowser.zipUseTempFile:true}")
    private boolean zipUseTempFile;
    @Value(value="${admintool.filebrowser.zipCompessionLevel:1}")
    private byte zipCompessionLevel;
    @Value(value="${admintool.filebrowser.zipTempDir:'sys:java.io.tmpdir'}")
    private String zipTempDir;
    @Value(value="${admintool.filebrowser.downloadAllowed:true}")
    private boolean downloadAllowed;
    @Value(value="${admintool.filebrowser.downloadCompressedAllowed:true}")
    private boolean downloadCompressedAllowed;
    @Value(value="#{'${admintool.filebrowser.securityRoles:}'.split(';')}")
    private Set<String> securityRoles = new HashSet<String>();
    @Value(value="${admintool.filebrowser.componentPosition:}")
    private Integer componentPosition;
    @Value(value="${admintool.filebrowser.uploadAllowed:false}")
    private boolean uploadAllowed;
    @Value(value="${admintool.filebrowser.createFolderAllowed:false}")
    private boolean createFolderAllowed;
    @Value(value="${admintool.filebrowser.delteFolderAllowed:false}")
    private boolean delteFolderAllowed;
    @Value(value="${admintool.filebrowser.delteFileAllowed:false}")
    private boolean delteFileAllowed;
    @Value(value="${admintool.filebrowser.notDeletableIfNotWriteable:true}")
    private boolean notDeletableIfNotWriteable;
    @Value(value="${admintool.filebrowser.info.crc32:true}")
    private boolean infoCrc32;
    @Value(value="${admintool.filebrowser.info.md5:true}")
    private boolean infoMD5;
    @Value(value="${admintool.filebrowser.info.sha1:true}")
    private boolean infoSha1;
    @Value(value="${admintool.filebrowser.info.sha256:false}")
    private boolean infoSha256;
    @Value(value="${admintool.filebrowser.info.maxFilesizeForHashes:1000000000}")
    private long maxFilesizeForHashes;
    @Value(value="${admintool.filebrowser.info.countFolderSize:true}")
    private boolean countFolderSize;

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isHideMenuItem() {
        return this.hideMenuItem;
    }

    public File getStartDir() {
        if (StringUtils.isEmpty((Object)this.startDir)) {
            return new File(this.getClass().getClassLoader().getResource("").getPath());
        }
        File start = new File(this.startDir);
        return start.isFile() ? start.getParentFile() : start;
    }

    public List<String> getForbiddenDrives() {
        return this.forbiddenDrives;
    }

    public boolean isReadOnly() {
        return this.isEnabled() && this.readOnly;
    }

    public boolean isRestrictedBrowsing() {
        return this.restrictedBrowsing;
    }

    public boolean isRestrictedBrowsingIsWhitelist() {
        return this.restrictedBrowsingIsWhitelist;
    }

    public List<String> getRestrictedPaths() {
        return this.restrictedPaths;
    }

    public long getSizeDivisorMultiplicator() {
        return this.sizeDivisorMultiplicator;
    }

    public void setSizeDivisorMultiplicator(long sizeDivisorMultiplicator) {
        this.sizeDivisorMultiplicator = sizeDivisorMultiplicator;
    }

    public byte getFileSizeDisplayScale() {
        return this.fileSizeDisplayScale;
    }

    public void setFileSizeDisplayScale(byte fileSizeDisplayScale) {
        this.fileSizeDisplayScale = fileSizeDisplayScale;
    }

    public boolean isZipUseTempFile() {
        return this.zipUseTempFile;
    }

    public String getZipTempDir() {
        if (this.zipTempDir.charAt(0) == '\'') {
            return this.zipTempDir.substring(1).substring(0, this.zipTempDir.length() - 2);
        }
        return this.zipTempDir;
    }

    public byte getZipCompessionLevel() {
        return this.zipCompessionLevel;
    }

    public boolean isDownloadAllowed() {
        return this.isEnabled() && this.downloadAllowed;
    }

    public boolean isDownloadCompressedAllowed() {
        return this.isEnabled() && this.downloadCompressedAllowed;
    }

    public Set<String> getSecurityRoles() {
        return this.securityRoles;
    }

    public Integer getComponentPosition() {
        return this.componentPosition;
    }

    public void setComponentPosition(Integer componentPosition) {
        this.componentPosition = componentPosition;
    }

    public boolean isManipulationAllowed() {
        return !this.readOnly && (this.uploadAllowed || this.createFolderAllowed);
    }

    public boolean isUploadAllowed() {
        return this.isEnabled() && this.uploadAllowed;
    }

    public boolean isCreateFolderAllowed() {
        return this.isEnabled() && this.createFolderAllowed;
    }

    public boolean isDelteFolderAllowed() {
        return this.isEnabled() && this.delteFolderAllowed;
    }

    public boolean isDelteFileAllowed() {
        return this.isEnabled() && this.delteFileAllowed;
    }

    public boolean isNotDeletableIfNotWriteable() {
        return this.notDeletableIfNotWriteable;
    }

    public boolean isInfoCrc32() {
        return this.infoCrc32;
    }

    public void setInfoCrc32(boolean infoCrc32) {
        this.infoCrc32 = infoCrc32;
    }

    public boolean isInfoMD5() {
        return this.infoMD5;
    }

    public void setInfoMD5(boolean infoMD5) {
        this.infoMD5 = infoMD5;
    }

    public boolean isInfoSha1() {
        return this.infoSha1;
    }

    public void setInfoSha1(boolean infoSha1) {
        this.infoSha1 = infoSha1;
    }

    public boolean isInfoSha256() {
        return this.infoSha256;
    }

    public void setInfoSha256(boolean infoSha256) {
        this.infoSha256 = infoSha256;
    }

    public long getMaxFilesizeForHashes() {
        return this.maxFilesizeForHashes;
    }

    public void setMaxFilesizeForHashes(long maxFilesizeForHashes) {
        this.maxFilesizeForHashes = maxFilesizeForHashes;
    }

    public boolean isCountFolderSize() {
        return this.countFolderSize;
    }

    public void setCountFolderSize(boolean countFolderSize) {
        this.countFolderSize = countFolderSize;
    }

    @PostConstruct
    public void printConfig() {
        LOGGER.debug((Object)this.toString());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AdminToolFilebrowserConfig [enabled=").append(this.enabled).append(", hideMenuItem=").append(this.hideMenuItem).append(", startDir=").append(this.startDir).append(", forbiddenDrives=").append(this.forbiddenDrives).append(", readOnly=").append(this.readOnly).append(", restrictedBrowsing=").append(this.restrictedBrowsing).append(", restrictedBrowsingIsWhitelist=").append(this.restrictedBrowsingIsWhitelist).append(", restrictedPaths=").append(this.restrictedPaths).append(", sizeDivisorMultiplicator=").append(this.sizeDivisorMultiplicator).append(", fileSizeDisplayScale=").append(this.fileSizeDisplayScale).append(", zipUseTempFile=").append(this.zipUseTempFile).append(", zipCompessionLevel=").append(this.zipCompessionLevel).append(", zipTempDir=").append(this.zipTempDir).append(", downloadAllowed=").append(this.downloadAllowed).append(", downloadCompressedAllowed=").append(this.downloadCompressedAllowed).append(", securityRoles=").append(this.securityRoles).append(", componentPosition=").append(this.componentPosition).append(", uploadAllowed=").append(this.uploadAllowed).append(", createFolderAllowed=").append(this.createFolderAllowed).append(", delteFolderAllowed=").append(this.delteFolderAllowed).append(", delteFileAllowed=").append(this.delteFileAllowed).append(", infoCrc32=").append(this.infoCrc32).append(", infoMD5=").append(this.infoMD5).append(", infoSha1=").append(this.infoSha1).append(", infoSha256=").append(this.infoSha256).append(", maxFilesizeForHashes=").append(this.maxFilesizeForHashes).append(", countFolderSize=").append(this.countFolderSize).append("]");
        return builder.toString();
    }
}

