/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.filebrowser;

import de.chandre.admintool.filebrowser.AdminToolFilebrowserConfig;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractFileBrowserService {
    @Autowired
    private AdminToolFilebrowserConfig config;

    public String encodeURL(String path) throws UnsupportedEncodingException {
        return URLEncoder.encode(path, "UTF-8");
    }

    public boolean isAllowed(File path, boolean write, boolean configReadOnly) throws IOException {
        try {
            if (configReadOnly && write) {
                return false;
            }
            if (this.config.isRestrictedBrowsing()) {
                if (null != this.config.getRestrictedPaths() && null != path) {
                    for (String restricedPath : this.config.getRestrictedPaths()) {
                        if (!path.getCanonicalPath().startsWith(restricedPath)) continue;
                        return this.config.isRestrictedBrowsingIsWhitelist();
                    }
                }
                return !this.config.isRestrictedBrowsingIsWhitelist();
            }
        }
        catch (IOException e) {
            throw new IOException("Could not check if path '" + path.getAbsolutePath() + "' is allowed ", e);
        }
        return true;
    }

    public String getExtension(File file) {
        return this.getExtension(file.getName());
    }

    public String getExtension(String fileName) {
        if (fileName.lastIndexOf(46) > -1) {
            return fileName.substring(fileName.lastIndexOf(46) + 1, fileName.length()).toLowerCase();
        }
        return null;
    }
}

