/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.db;

import de.chandre.admintool.db.AdminToolDBBrowserConfig;
import de.chandre.admintool.db.AdminToolDBBrowserExampleLoader;
import de.chandre.admintool.db.AdminToolDBBrowserService;
import de.chandre.admintool.db.ConnectionVars;
import de.chandre.admintool.db.ExampleStatement;
import de.chandre.admintool.db.QueryResultTO;
import de.chandre.admintool.db.StatementTO;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="adminToolDBBrowserService")
public class AdminToolDBBrowserServiceImpl
implements AdminToolDBBrowserService {
    private static final Log LOGGER = LogFactory.getLog(AdminToolDBBrowserServiceImpl.class);
    private static final String DEFAULT_CLOB_ENCODING = "UTF-8";
    private static final String META_KEY_DB_VERSION = "databaseProductVersion";
    private static final String META_KEY_DRIVER_VERSION = "driverVersion";
    private static final String META_KEY_DRIVER_NAME = "driverName";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private AdminToolDBBrowserConfig configuration;
    @Autowired
    private Map<String, DataSource> datasources;
    @Autowired
    private AdminToolDBBrowserExampleLoader exampleLoader;

    @Override
    public Map<String, DataSource> getDatasources() {
        return this.datasources;
    }

    @Override
    public void setDatasources(Map<String, DataSource> datasources) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("receiving " + (null != datasources ? Integer.valueOf(datasources.size()) : "null") + " datasources"));
        }
        this.datasources = datasources;
    }

    @Override
    public List<String> getDatasourceNames() {
        if (null == this.datasources) {
            this.datasources = this.applicationContext.getBeansOfType(DataSource.class);
        }
        ArrayList<String> result = new ArrayList<String>(this.datasources.keySet());
        Collections.sort(result);
        return result;
    }

    protected boolean isDMLAllowed() {
        return this.configuration.isDmlAllowed();
    }

    @Override
    public Connection getConnection(String datasourceName, ConnectionVars vars) throws SQLException {
        DataSource ds = this.datasources.get(datasourceName);
        if (null == ds) {
            throw new IllegalArgumentException("no datasource with name '" + datasourceName + "' found");
        }
        Connection c = ds.getConnection();
        if (!this.isDMLAllowed() && null != vars) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"DML is not allowed. Set autoCommit to false and readOnly to true.");
            }
            vars.setOrgAutoCommitState(c.getAutoCommit());
            vars.setOrgReadOnlyState(c.isReadOnly());
            c.setAutoCommit(false);
            c.setReadOnly(true);
        }
        return c;
    }

    @Override
    public void closeConnection(Connection c, ConnectionVars vars) {
        if (!this.isDMLAllowed() && c != null && null != vars) {
            try {
                c.rollback();
                c.setAutoCommit(vars.isOrgAutoCommitState());
                c.setReadOnly(vars.isOrgReadOnlyState());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (null != c) {
            try {
                c.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResultTO getMetadata(String datasourceName) {
        if (!this.configuration.isEnabled()) {
            return null;
        }
        QueryResultTO resultTO = new QueryResultTO();
        Connection c = null;
        try {
            c = this.getConnection(datasourceName, null);
            DatabaseMetaData metadata = c.getMetaData();
            resultTO.addMetadata(META_KEY_DB_VERSION, metadata.getDatabaseProductVersion());
            resultTO.addMetadata(META_KEY_DRIVER_VERSION, metadata.getDriverVersion());
            resultTO.addMetadata(META_KEY_DRIVER_NAME, metadata.getDriverName());
            if (!this.configuration.isLoadMetaData()) {
                QueryResultTO queryResultTO = resultTO;
                return queryResultTO;
            }
            ResultSet resSet = metadata.getTables(null, null, null, null);
            StatementTO statementTO = new StatementTO();
            statementTO.setShowClobs(true);
            this.iterateResult(resSet, resultTO, statementTO);
            int colTableName = -1;
            int colSchemaName = -1;
            int i = 0;
            for (String colName : resultTO.getColumnsNames()) {
                if (colName.toLowerCase(Locale.ENGLISH).startsWith("table_name")) {
                    colTableName = i;
                }
                if (colName.toLowerCase(Locale.ENGLISH).startsWith("table_sche")) {
                    colSchemaName = i;
                }
                ++i;
            }
            HashMap tablesAndColums = new HashMap();
            for (List<String> row : resultTO.getTableResult()) {
                String schemaName = colSchemaName > -1 ? row.get(colSchemaName) : null;
                String tableName = colTableName > -1 ? row.get(colTableName) : null;
                ResultSet tableResSet = metadata.getColumns(null, schemaName, tableName, null);
                QueryResultTO tableResultTO = new QueryResultTO();
                this.iterateResult(tableResSet, tableResultTO, statementTO);
                int colColumnName = -1;
                i = 0;
                for (String colName : tableResultTO.getColumnsNames()) {
                    if (colName.toLowerCase(Locale.ENGLISH).startsWith("column_name")) {
                        colColumnName = i;
                    }
                    ++i;
                }
                HashSet<String> colums = new HashSet<String>();
                for (List<String> colRow : tableResultTO.getTableResult()) {
                    String columnName = colColumnName > -1 ? colRow.get(colColumnName) : null;
                    if (null == columnName) continue;
                    colums.add(columnName);
                }
                if (tablesAndColums.containsKey(tableName)) {
                    LOGGER.info((Object)String.format("duplicate table found: %s (schema is: %s)", tableName, schemaName));
                }
                tablesAndColums.put(tableName, colums);
            }
            resultTO.setTableResult(null);
            resultTO.addMetadata("tables", tablesAndColums);
        }
        catch (Exception e) {
            resultTO.setExceptionMessage(e.getMessage());
            resultTO.setExceptionCause(null != e.getCause() ? e.getCause().toString() : null);
            resultTO.setExceptionTrace(AdminToolDBBrowserServiceImpl.printException(e));
        }
        finally {
            this.closeConnection(c, null);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)resultTO);
        }
        return resultTO;
    }

    private String prepareQuery(StatementTO statementTO) {
        String strQuery = statementTO.getStatement();
        if (statementTO.isBaseEncoded()) {
            strQuery = new String(Base64.decodeBase64((String)strQuery));
        }
        if (!strQuery.toLowerCase().contains("begin") && !strQuery.toLowerCase().contains("end;") && strQuery.endsWith(";")) {
            strQuery = strQuery.substring(0, strQuery.length() - 1);
        }
        return strQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResultTO queryDatabase(StatementTO statementTO) {
        if (!this.configuration.isEnabled()) {
            return null;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)statementTO);
        }
        ConnectionVars vars = new ConnectionVars();
        QueryResultTO resultTO = new QueryResultTO(statementTO);
        if (StringUtils.isEmpty((Object)statementTO.getStatement())) {
            return resultTO;
        }
        Connection c = null;
        try {
            c = this.getConnection(statementTO.getDatasourceName(), vars);
            Statement st = c.createStatement();
            if (0 < statementTO.getMaxResults()) {
                st.setMaxRows(statementTO.getMaxResults());
            }
            String strQuery = this.prepareQuery(statementTO);
            LOGGER.trace((Object)("executing query: " + strQuery));
            if (strQuery.toLowerCase().startsWith("select")) {
                ResultSet resSet = null;
                resSet = st.executeQuery(strQuery);
                this.iterateResult(resSet, resultTO, statementTO);
            } else {
                resultTO.setAffectedRows(st.executeUpdate(strQuery));
                resultTO.setSelect(false);
            }
        }
        catch (Exception e) {
            resultTO.setExceptionMessage(e.getMessage());
            resultTO.setExceptionCause(null != e.getCause() ? e.getCause().toString() : null);
            resultTO.setExceptionTrace(AdminToolDBBrowserServiceImpl.printException(e));
        }
        finally {
            this.closeConnection(c, vars);
        }
        if (!this.configuration.isShowMetaDataLoadException()) {
            if (null != resultTO.getExceptionMessage() || null != resultTO.getExceptionTrace()) {
                LOGGER.debug((Object)("Exception while fetching database meta data: " + resultTO.getExceptionMessage()));
                LOGGER.debug((Object)resultTO.getExceptionCause());
                LOGGER.debug((Object)resultTO.getExceptionTrace());
            }
            resultTO.setExceptionMessage(null);
            resultTO.setExceptionCause(null);
            resultTO.setExceptionTrace(null);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)resultTO);
        }
        return resultTO;
    }

    protected void iterateResult(ResultSet resSet, QueryResultTO resultTO, StatementTO statementTO) {
        try {
            if (resSet != null && !resSet.isClosed()) {
                String clobEncoding;
                ResultSetMetaData metaData = resSet.getMetaData();
                int cols = metaData.getColumnCount();
                HashMap<Integer, Integer> type = new HashMap<Integer, Integer>();
                ArrayList<String> columnsNames = new ArrayList<String>();
                for (int i = 1; i < cols + 1; ++i) {
                    String colName = metaData.getColumnName(i);
                    columnsNames.add(colName);
                    type.put(i, metaData.getColumnType(i));
                }
                ArrayList<List<String>> tableResult = new ArrayList<List<String>>();
                String string = clobEncoding = statementTO.getClobEncoding() != null ? statementTO.getClobEncoding() : DEFAULT_CLOB_ENCODING;
                while (resSet.next()) {
                    ArrayList<String> row = new ArrayList<String>();
                    for (int i = 1; i < cols + 1; ++i) {
                        if (type.get(i) != null && (Integer)type.get(i) == 2004) {
                            if (statementTO.isShowBlobs()) {
                                row.add(String.valueOf(new String(resSet.getBytes(i))));
                                continue;
                            }
                            row.add(String.valueOf(resSet.getObject(i)));
                            continue;
                        }
                        if (type.get(i) != null && (Integer)type.get(i) == 2005) {
                            if (statementTO.isShowClobs()) {
                                row.add(this.getClobString(resSet.getClob(i), clobEncoding));
                                continue;
                            }
                            row.add("CLOB content");
                            continue;
                        }
                        row.add(String.valueOf(resSet.getObject(i)));
                    }
                    tableResult.add(row);
                }
                resultTO.setSqlWarnings(null != resSet.getWarnings() ? resSet.getWarnings().toString() : null);
                resultTO.setAffectedRows(tableResult.size());
                resultTO.setColumnsNames(columnsNames);
                resultTO.setTableResult(tableResult);
            } else {
                resultTO.setSqlWarnings("resultSet was " + (null != resSet ? "closed already" : "null"));
            }
            resultTO.setSelect(true);
        }
        catch (Exception e) {
            resultTO.setExceptionMessage(e.getMessage());
            resultTO.setExceptionCause(null != e.getCause() ? e.getCause().toString() : null);
            resultTO.setExceptionTrace(AdminToolDBBrowserServiceImpl.printException(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getClobString(Clob clobObject, String encoding) throws IOException, SQLException, UnsupportedEncodingException {
        if (null == clobObject) {
            return "";
        }
        InputStream in = clobObject.getAsciiStream();
        InputStreamReader read = new InputStreamReader(in, encoding);
        StringWriter write = new StringWriter();
        String result = null;
        try {
            int c = -1;
            while ((c = ((Reader)read).read()) != -1) {
                write.write(c);
            }
            write.flush();
            result = write.toString();
        }
        finally {
            AdminToolDBBrowserServiceImpl.closeStream(write);
            AdminToolDBBrowserServiceImpl.closeStream(read);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String printException(Throwable throwable) {
        if (null == throwable) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(baos);
        throwable.printStackTrace(printStream);
        String exceptionStr = "";
        try {
            exceptionStr = baos.toString(DEFAULT_CLOB_ENCODING);
        }
        catch (Exception ex) {
            exceptionStr = "Unavailable";
        }
        finally {
            AdminToolDBBrowserServiceImpl.closeStream(printStream);
            AdminToolDBBrowserServiceImpl.closeStream(baos);
        }
        return exceptionStr;
    }

    protected static void closeStream(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public String getTab(StatementTO statementTO, String id) {
        return null != statementTO ? id + "_" + String.valueOf(statementTO.getTab()) : id + "_1";
    }

    @Override
    public Map<String, List<ExampleStatement>> getExamplesForDatasource(StatementTO statementTO) {
        if (null == this.exampleLoader.getExamples() || this.exampleLoader.getExamples().isEmpty()) {
            return null;
        }
        String dataSourceName = this.datasources.keySet().iterator().next();
        if (null != statementTO) {
            dataSourceName = statementTO.getDatasourceName();
        }
        return this.exampleLoader.getExamples().get(dataSourceName);
    }
}

