/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.db;

import de.chandre.admintool.core.AbstractAdminToolLoader;
import de.chandre.admintool.core.AdminTool;
import de.chandre.admintool.core.component.AdminComponent;
import de.chandre.admintool.core.component.AdminComponentImpl;
import de.chandre.admintool.core.component.MenuEntry;
import de.chandre.admintool.db.AdminToolDBBrowserConfig;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AdminToolDBBrowserLoader
extends AbstractAdminToolLoader {
    private static final Log LOGGER = LogFactory.getLog(AdminToolDBBrowserLoader.class);
    @Autowired
    private AdminTool adminTool;
    @Autowired
    private AdminToolDBBrowserConfig config;

    @PostConstruct
    public AdminTool configureAdminTool() {
        if (!this.config.isEnabled()) {
            LOGGER.info((Object)" admin tool's database browser deactivated");
            return this.adminTool;
        }
        LOGGER.info((Object)"adding database browser to admin tool");
        boolean relative = !this.shouldCDNsUsed();
        String commonPrefix = this.getWebjarsPrefixUri();
        AdminComponentImpl component = new AdminComponentImpl();
        component.setDisplayName("DB Browser");
        component.addAdditionalJS("/static/admintool/dbbrowser/js/dbbrowser.js", true);
        String codeMirrorPrefix = commonPrefix + "codemirror/" + this.config.getCodeMirrorVersion() + "/";
        component.addAdditionalJS(codeMirrorPrefix + "lib/codemirror.js", relative);
        component.addAdditionalJS(codeMirrorPrefix + "mode/meta.js", relative);
        component.addAdditionalJS(codeMirrorPrefix + "mode/sql/sql.js", relative);
        component.addAdditionalJS(codeMirrorPrefix + "addon/edit/matchbrackets.js", relative);
        component.addAdditionalJS(codeMirrorPrefix + "addon/mode/loadmode.js", relative);
        component.addAdditionalJS(codeMirrorPrefix + "addon/hint/show-hint.js", relative);
        component.addAdditionalJS(codeMirrorPrefix + "addon/hint/sql-hint.js", relative);
        component.addAdditionalCSS(codeMirrorPrefix + "lib/codemirror.css", relative);
        component.addAdditionalCSS(codeMirrorPrefix + "addon/hint/show-hint.css", relative);
        component.addAdditionalCSS("/static/admintool/dbbrowser/css/dbbrowser.css", true);
        MenuEntry mainMenu = new MenuEntry();
        mainMenu.setDisplayName("DB Browser");
        mainMenu.setName("dbbrowser");
        mainMenu.setTarget("dbbrowser/content/dbbrowser");
        component.setMainMenu(mainMenu);
        this.adminTool.addComponent((AdminComponent)component);
        return this.adminTool;
    }
}

