/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.db;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.chandre.admintool.db.ExampleStatement;
import de.chandre.admintool.db.ExampleStatements;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.springframework.stereotype.Component;

@Component
public class AdminToolDBBrowserExampleLoader {
    private static final Log LOGGER = LogFactory.getLog(AdminToolDBBrowserExampleLoader.class);
    private HashMap<String, Map<String, List<ExampleStatement>>> statements = new HashMap();

    public void addExamples(ExampleStatements exampleStatements) {
        this.statements.put(exampleStatements.getDatasourceName(), exampleStatements.getClusters());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("converted json object" + new JSONObject(this.statements)));
        }
    }

    public HashMap<String, Map<String, List<ExampleStatement>>> getExamples() {
        return this.statements;
    }

    public void loadExampleStatementsFromJsonString(String jsonString) throws JsonParseException, JsonMappingException, IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Receiving json string: " + jsonString));
        }
        ObjectMapper mapper = new ObjectMapper();
        ExampleStatements exampleStatements = (ExampleStatements)mapper.readValue(jsonString, ExampleStatements.class);
        this.addExamples(exampleStatements);
    }

    public void loadExampleStatementsFromJsonString(InputStream jsonStream) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        ExampleStatements exampleStatements = (ExampleStatements)mapper.readValue(jsonStream, ExampleStatements.class);
        this.addExamples(exampleStatements);
    }

    public void loadExampleStatementsFromJsonString(File jsonFile) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        ExampleStatements exampleStatements = (ExampleStatements)mapper.readValue(jsonFile, ExampleStatements.class);
        this.addExamples(exampleStatements);
    }

    public void loadExampleStatementsFromJsonString(byte[] jsonFile) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        ExampleStatements exampleStatements = (ExampleStatements)mapper.readValue(jsonFile, ExampleStatements.class);
        this.addExamples(exampleStatements);
    }

    public void loadExampleStatementsFromJsonString(URL jsonFile) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        ExampleStatements exampleStatements = (ExampleStatements)mapper.readValue(jsonFile, ExampleStatements.class);
        this.addExamples(exampleStatements);
    }

    public void loadExampleStatementsFromXMLString(String xmlString) throws JSONException, IllegalArgumentException, JsonParseException, JsonMappingException, IOException {
        JSONObject jsonobject;
        String[] root;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Receiving json string: " + xmlString));
        }
        if (null == (root = JSONObject.getNames((JSONObject)(jsonobject = XML.toJSONObject((String)xmlString))))) {
            throw new IllegalArgumentException("no root object in xml found");
        }
        if (root.length > 1) {
            throw new IllegalArgumentException("more than one root objects found");
        }
        JSONObject statement = jsonobject.getJSONObject(root[0]);
        this.loadExampleStatementsFromJsonString(statement.toString());
    }
}

