/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.db;

import de.chandre.admintool.core.controller.AbstractAdminController;
import de.chandre.admintool.db.AdminToolDBBrowserConfig;
import de.chandre.admintool.db.AdminToolDBBrowserExampleLoader;
import de.chandre.admintool.db.AdminToolDBBrowserService;
import de.chandre.admintool.db.QueryResultTO;
import de.chandre.admintool.db.StatementTO;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/admintool/dbbrowser"})
public class AdminToolDBBrowserController
extends AbstractAdminController {
    private static final Log LOGGER = LogFactory.getLog(AdminToolDBBrowserController.class);
    @Autowired
    private AdminToolDBBrowserService dbBrowserService;
    @Autowired
    private AdminToolDBBrowserConfig configuration;
    @Autowired
    private AdminToolDBBrowserExampleLoader exampleLoader;

    @RequestMapping(path={"/getDatasourceNames"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public List<String> getDatasourceNames(HttpServletRequest request) {
        if (!this.configuration.isEnabled()) {
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"receiving getDatasourceNames request");
        }
        return this.dbBrowserService.getDatasourceNames();
    }

    @RequestMapping(path={"/getMetaData/{datasourceName}"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public QueryResultTO getMetaData(@PathVariable(value="datasourceName") String datasourceName, HttpServletRequest request) {
        if (!this.configuration.isEnabled()) {
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"receiving getMetaData request");
        }
        return this.dbBrowserService.getMetadata(datasourceName);
    }

    @RequestMapping(path={"/getExamples"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public String getExamples(HttpServletRequest request) {
        if (!this.configuration.isEnabled()) {
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"receiving getDatasourceNames request");
        }
        return new JSONObject(this.exampleLoader.getExamples()).toString();
    }

    @RequestMapping(path={"/executeQuery"}, method={RequestMethod.POST})
    public String executeQuery(@RequestBody StatementTO statementTO, ModelMap model, HttpServletRequest request) {
        if (!this.configuration.isEnabled()) {
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"receiving executeQuery request");
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("with object: " + statementTO.toString()));
        }
        model.put((Object)"statementTO", (Object)statementTO);
        model.put((Object)"queryResultTO", (Object)this.dbBrowserService.queryDatabase(statementTO));
        return "admintool/dbbrowser/includes/tabInclude";
    }

    public AdminToolDBBrowserService getDbBrowserService() {
        return this.dbBrowserService;
    }

    public void setDbBrowserService(AdminToolDBBrowserService dbBrowserService) {
        this.dbBrowserService = dbBrowserService;
    }
}

