/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.db;

import de.chandre.admintool.core.AdminToolConfig;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="adminToolDBBrowserConfig")
public class AdminToolDBBrowserConfig
implements AdminToolConfig {
    private static final Log LOGGER = LogFactory.getLog(AdminToolDBBrowserConfig.class);
    @Value(value="${admintool.dbbrowser.enabled:true}")
    private boolean enabled;
    @Value(value="${admintool.dbbrowser.dmlAllowed:false}")
    private boolean dmlAllowed;
    @Value(value="${admintool.dbbrowser.clobEncodings:}")
    private List<String> clobEncodings = new ArrayList<String>();
    @Value(value="${admintool.dbbrowser.codeMirrorVersion:5.13.2}")
    private String codeMirrorVersion;

    @PostConstruct
    public void setDefaults() {
        if (this.clobEncodings.isEmpty() || this.clobEncodings.size() == 1 && StringUtils.isEmpty((Object)this.clobEncodings.iterator().next())) {
            LOGGER.info((Object)"using default clob encoding configuration");
            this.clobEncodings = new ArrayList<String>();
            this.clobEncodings.add("UTF-8");
            this.clobEncodings.add("ISO-8859-1");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("clob encoding is empty: " + this.clobEncodings.isEmpty() + ", size: " + this.clobEncodings.size()));
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isDmlAllowed() {
        return this.dmlAllowed;
    }

    public void setDmlAllowed(boolean dmlAllowed) {
        this.dmlAllowed = dmlAllowed;
    }

    public List<String> getClobEncodings() {
        return this.clobEncodings;
    }

    public void setClobEncodings(List<String> clobEncodings) {
        this.clobEncodings = clobEncodings;
    }

    public String getCodeMirrorVersion() {
        return this.codeMirrorVersion;
    }

    public void setCodeMirrorVersion(String codeMirrorVersion) {
        this.codeMirrorVersion = codeMirrorVersion;
    }
}

