/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.core.utils;

import de.chandre.admintool.core.AdminTool;
import de.chandre.admintool.core.component.AdminComponent;
import de.chandre.admintool.core.component.MenuEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="adminToolMenuUtils")
public class AdminToolMenuUtils {
    private static final Log LOGGER = LogFactory.getLog(AdminToolMenuUtils.class);
    private static final String DEAULT_BC_SEP = " &gt; ";
    private static final String CSS_TREEVIEW = "treeview";
    private static final String CSS_ACTIVE = " active";
    @Autowired
    private AdminTool adminTool;

    public static String normalizeTarget(String target) {
        if (target.startsWith("/")) {
            target = target.substring(1, target.length());
        }
        return target;
    }

    public List<AdminComponent> getComponents() {
        ArrayList<AdminComponent> result = new ArrayList<AdminComponent>();
        for (AdminComponent adminComponent : this.adminTool.getComponents()) {
            if (null == adminComponent.getMainMenu()) continue;
            Stream<MenuEntry> nonHiddenMenues = adminComponent.getMainMenu().flattened().filter(me -> !me.isHide());
            if (nonHiddenMenues.count() == 0L) {
                LOGGER.trace((Object)("all menu entries hidden for component: " + adminComponent.getDisplayName()));
                continue;
            }
            result.add(adminComponent);
        }
        return result;
    }

    public String getMenuName(HttpServletRequest request, String overrideName) {
        if (!StringUtils.isEmpty((Object)overrideName)) {
            return overrideName;
        }
        String name = request.getRequestURI().replaceFirst("/admintool", "");
        if (!StringUtils.isEmpty((Object)request.getContextPath())) {
            name = name.replaceFirst(request.getContextPath(), "");
        }
        if (name.startsWith("/")) {
            name = name.substring(1, name.length());
        }
        return name;
    }

    public String getListItemClass(MenuEntry activeMenu, MenuEntry actualEntry) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("[getListItemClass]" + actualEntry));
        }
        StringBuilder sb = new StringBuilder();
        if (!CollectionUtils.isEmpty(actualEntry.getSubmenu())) {
            sb.append(CSS_TREEVIEW);
        }
        if (this.isActiveInMenuTree(activeMenu, actualEntry)) {
            sb.append(CSS_ACTIVE);
        }
        return sb.toString().trim();
    }

    public boolean isActiveInMenuTree(MenuEntry activeMenu, MenuEntry actualEntry) {
        return actualEntry.flattened().anyMatch(entry -> this.checkForNull((MenuEntry)entry, activeMenu) ? entry.getName().equals(activeMenu.getName()) : false);
    }

    public String getBreadcrumb(MenuEntry actualEntry, String separator) {
        if (null == actualEntry) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        String sep = StringUtils.isEmpty((Object)separator) ? DEAULT_BC_SEP : separator;
        actualEntry.reverseFlattened().collect(AdminToolMenuUtils.toListReversed()).forEach(entry -> result.append(entry.getDisplayName()).append(sep));
        String result2 = result.toString();
        result2 = result2.substring(0, result2.lastIndexOf(sep));
        return result2.trim().toString();
    }

    public List<MenuEntry> getBreadcrumbList(MenuEntry actualEntry) {
        LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
        if (null != actualEntry) {
            actualEntry.reverseFlattened().collect(AdminToolMenuUtils.toListReversed()).forEach(entry -> {
                if (null != entry) {
                    result.add((MenuEntry)entry);
                }
            });
        }
        return result;
    }

    public static <T> Collector<T, ?, List<T>> toListReversed() {
        return Collectors.collectingAndThen(Collectors.toList(), l -> {
            Collections.reverse(l);
            return l;
        });
    }

    public boolean hasMenuEntry(AdminComponent component, MenuEntry activeMenue) {
        if (null != component && null != component.getMainMenu()) {
            Optional<MenuEntry> result = component.getMainMenu().flattened().filter(menu -> this.checkForNull((MenuEntry)menu, activeMenue) ? menu.getName().equals(activeMenue.getName()) : false).findFirst();
            return result.isPresent();
        }
        return false;
    }

    private boolean checkForNull(MenuEntry menu, MenuEntry activeMenu) {
        return null != menu && null != menu.getName() && null != activeMenu && null != activeMenu.getName();
    }
}

