/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.core.thymeleaf;

import de.chandre.admintool.core.thymeleaf.OrderedClassLoaderTemplateResolver;
import java.nio.charset.Charset;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.thymeleaf.spring4.SpringTemplateEngine;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Configuration
public class ThymeleafResolverExtension {
    private static final Log LOGGER = LogFactory.getLog(ThymeleafResolverExtension.class);
    public static final String DEFAULT_PREFIX = "classpath:/templates/";
    public static final String DEFAULT_SUFFIX = ".html";
    @Autowired
    private SpringTemplateEngine templateEngine;
    @Value(value="${spring.thymeleaf.prefix:#{T(de.chandre.admintool.core.thymeleaf.ThymeleafResolverExtension).DEFAULT_PREFIX}}")
    private String prefix;
    @Value(value="${spring.thymeleaf.suffix:#{T(de.chandre.admintool.core.thymeleaf.ThymeleafResolverExtension).DEFAULT_SUFFIX}}")
    private String suffix;
    @Value(value="${spring.thymeleaf.mode:HTML5}")
    private String mode;
    @Value(value="#{T(java.nio.charset.Charset).forName('${spring.thymeleaf.encoding:UTF-8}')}")
    private Charset encoding;
    @Value(value="${spring.thymeleaf.cache:true}")
    private boolean cache;

    @PostConstruct
    public void extension() {
        LOGGER.info((Object)this.toString());
        OrderedClassLoaderTemplateResolver resolver = new OrderedClassLoaderTemplateResolver();
        resolver.setOrder(this.templateEngine.getTemplateResolvers().size());
        resolver.setPrefix(this.prefix);
        resolver.setSuffix(this.suffix);
        resolver.setTemplateMode(this.mode);
        if (this.encoding != null) {
            resolver.setCharacterEncoding(this.encoding.name());
        }
        resolver.setCacheable(this.cache);
        this.templateEngine.addTemplateResolver((ITemplateResolver)resolver);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ThymeleafResolverExtension [prefix=").append(this.prefix).append(", suffix=").append(this.suffix).append(", mode=").append(this.mode).append(", encoding=").append(this.encoding).append(", cache=").append(this.cache).append("]");
        return builder.toString();
    }
}

