/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.core.component;

import de.chandre.admintool.core.component.AdminComponent;
import de.chandre.admintool.core.utils.AdminToolMenuUtils;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.springframework.util.CollectionUtils;

public class MenuEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String displayName;
    private String resouceMessageKey;
    private String target;
    private boolean hide = false;
    private String activeName;
    private AdminComponent component;
    private MenuEntry parent;
    private List<MenuEntry> submenu = new LinkedList<MenuEntry>();
    private boolean useCCSHierarchy = false;
    private Map<String, Boolean> additionalCSS = new LinkedHashMap<String, Boolean>(1);
    private boolean useJSHierarchy = false;
    private Map<String, Boolean> additionalJS = new LinkedHashMap<String, Boolean>(1);
    private Set<String> securityRoles = new HashSet<String>();
    private Map<String, Object> variables = new HashMap<String, Object>();

    public MenuEntry() {
        this.hide = false;
    }

    public MenuEntry(String name, String displayName, String target) {
        this.name = name;
        this.displayName = displayName;
        this.target = target;
        this.hide = false;
    }

    public MenuEntry(String name, String displayName, String target, Set<String> securityRoles) {
        this.name = name;
        this.displayName = displayName;
        this.target = target;
        this.hide = false;
        this.securityRoles = securityRoles;
    }

    void setComponent(AdminComponent component) {
        this.component = component;
    }

    AdminComponent getComponent() {
        return this.component;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getResouceMessageKey() {
        return this.resouceMessageKey;
    }

    public void setResouceMessageKey(String resouceMessageKey) {
        this.resouceMessageKey = resouceMessageKey;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String targetTemplatePath) {
        this.target = AdminToolMenuUtils.normalizeTarget(targetTemplatePath);
    }

    public boolean isHide() {
        return this.hide;
    }

    public void setHide(boolean hide) {
        this.hide = hide;
    }

    public String getActiveName() {
        return this.activeName;
    }

    public void setActiveName(String activeName) {
        this.activeName = activeName;
    }

    public MenuEntry getParent() {
        return this.parent;
    }

    public void setParent(MenuEntry parent) {
        this.parent = parent;
    }

    public List<MenuEntry> getSubmenu() {
        return this.submenu;
    }

    public void setSubmenu(List<MenuEntry> submenu) {
        submenu.stream().forEach(entry -> entry.setParent(this));
        this.submenu = submenu;
    }

    public void addSubmenuEntry(MenuEntry submenu) {
        submenu.setParent(this);
        this.submenu.add(submenu);
    }

    public Stream<MenuEntry> flattened() {
        return Stream.concat(Stream.of(this), this.submenu.stream().flatMap(MenuEntry::flattened));
    }

    public Stream<MenuEntry> reverseFlattened() {
        if (null == this.parent) {
            return Stream.of(this);
        }
        return Stream.concat(Stream.of(this), Stream.of(this.parent).flatMap(MenuEntry::reverseFlattened));
    }

    public Map<String, Boolean> getAdditionalCSS() {
        return this.additionalCSS;
    }

    public void setAdditionalCSS(Map<String, Boolean> additionalCSS) {
        this.additionalCSS = additionalCSS;
    }

    public void addAdditionalCSS(String additionalCSS, boolean relative) {
        this.additionalCSS.put(additionalCSS, relative);
    }

    public Map<String, Boolean> getAdditionalCSSReverse() {
        LinkedHashMap<String, Boolean> result = new LinkedHashMap<String, Boolean>();
        List<MenuEntry> parents = this.reverseFlattened().collect(AdminToolMenuUtils.toListReversed());
        parents.forEach(menuEntry -> {
            if (null != menuEntry.getAdditionalCSS()) {
                result.putAll(menuEntry.getAdditionalCSS());
            }
        });
        return result;
    }

    public boolean isUseCCSHierarchy() {
        return this.useCCSHierarchy;
    }

    public void setUseCCSHierarchy(boolean useCCSHierarchy) {
        this.useCCSHierarchy = useCCSHierarchy;
    }

    public Map<String, Boolean> getAdditionalJS() {
        return this.additionalJS;
    }

    public void setAdditionalJS(Map<String, Boolean> additionalJS) {
        this.additionalJS = additionalJS;
    }

    public void addAdditionalJS(String additionalJS, boolean relative) {
        this.additionalJS.put(additionalJS, relative);
    }

    public Map<String, Boolean> getAdditionalJSReverse() {
        LinkedHashMap<String, Boolean> result = new LinkedHashMap<String, Boolean>();
        List<MenuEntry> parents = this.reverseFlattened().collect(AdminToolMenuUtils.toListReversed());
        parents.forEach(menuEntry -> {
            if (null != menuEntry.getAdditionalJS()) {
                result.putAll(menuEntry.getAdditionalJS());
            }
        });
        return result;
    }

    public boolean isUseJSHierarchy() {
        return this.useJSHierarchy;
    }

    public void setUseJSHierarchy(boolean useJSHierarchy) {
        this.useJSHierarchy = useJSHierarchy;
    }

    public Set<String> getAffectedSecurityRoles() {
        if (CollectionUtils.isEmpty(this.securityRoles)) {
            Stream<MenuEntry> parents = this.reverseFlattened();
            Iterator entry = parents.iterator();
            while (entry.hasNext()) {
                MenuEntry menuEntry = (MenuEntry)entry.next();
                if (!CollectionUtils.isEmpty(menuEntry.getSecurityRoles())) {
                    return Collections.unmodifiableSet(menuEntry.getSecurityRoles());
                }
                if (null == menuEntry.getComponent() || null == menuEntry.getComponent().getSecurityRoles()) continue;
                return Collections.unmodifiableSet(menuEntry.getComponent().getSecurityRoles());
            }
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.securityRoles);
    }

    public Set<String> getSecurityRoles() {
        return this.securityRoles;
    }

    public void setSecurityRoles(Set<String> securityRoles) {
        this.securityRoles = securityRoles;
    }

    public void addSecurityRole(String securityRole) {
        this.securityRoles.add(securityRole);
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public Object getVariable(String key) {
        return this.variables.get(key);
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public void addVariable(String key, Object variable) {
        this.variables.put(key, variable);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MenuEntry other = (MenuEntry)obj;
        if (this.activeName == null ? other.activeName != null : !this.activeName.equals(other.activeName)) {
            return false;
        }
        if (this.additionalCSS == null ? other.additionalCSS != null : !this.additionalCSS.equals(other.additionalCSS)) {
            return false;
        }
        if (this.additionalJS == null ? other.additionalJS != null : !this.additionalJS.equals(other.additionalJS)) {
            return false;
        }
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        if (this.hide != other.hide) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        if (this.resouceMessageKey == null ? other.resouceMessageKey != null : !this.resouceMessageKey.equals(other.resouceMessageKey)) {
            return false;
        }
        if (this.securityRoles == null ? other.securityRoles != null : !this.securityRoles.equals(other.securityRoles)) {
            return false;
        }
        if (this.submenu == null ? other.submenu != null : !this.submenu.equals(other.submenu)) {
            return false;
        }
        if (this.target == null ? other.target != null : !this.target.equals(other.target)) {
            return false;
        }
        if (this.useCCSHierarchy != other.useCCSHierarchy) {
            return false;
        }
        if (this.useJSHierarchy != other.useJSHierarchy) {
            return false;
        }
        return !(this.variables == null ? other.variables != null : !this.variables.equals(other.variables));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MenuEntry [name=").append(this.name).append(", displayName=").append(this.displayName).append(", resouceMessageKey=").append(this.resouceMessageKey).append(", target=").append(this.target).append(", hide=").append(this.hide).append(", submenu=").append(this.submenu).append(", additionalCSS=").append(this.additionalCSS).append(", additionalJS=").append(this.additionalJS).append(", securityRoles=").append(this.securityRoles).append(", variables=").append(this.variables).append("]");
        return builder.toString();
    }

    public static MenuEntryBuilder builder() {
        return new MenuEntryBuilder();
    }

    public static class MenuEntryBuilder {
        private MenuEntry entry = new MenuEntry();

        public MenuEntryBuilder name(String name) {
            this.entry.setName(name);
            return this;
        }

        public MenuEntryBuilder displayName(String displayName) {
            this.entry.setDisplayName(displayName);
            return this;
        }

        public MenuEntryBuilder resouceMessageKey(String resouceMessageKey) {
            this.entry.setResouceMessageKey(resouceMessageKey);
            return this;
        }

        public MenuEntryBuilder resouceMessageKeySuffix(String resouceMessageKey) {
            this.entry.setResouceMessageKey("ui.admintool.core." + resouceMessageKey);
            return this;
        }

        public MenuEntryBuilder target(String targetTemplatePath) {
            this.entry.setTarget(targetTemplatePath);
            return this;
        }

        public MenuEntryBuilder hide(boolean hide) {
            this.entry.setHide(hide);
            return this;
        }

        public MenuEntryBuilder activeName(String activeName) {
            this.entry.setActiveName(activeName);
            return this;
        }

        public MenuEntryBuilder submenu(List<MenuEntry> submenu) {
            this.entry.setSubmenu(submenu);
            return this;
        }

        public MenuEntryBuilder submenuEntry(MenuEntry submenu) {
            this.entry.addSubmenuEntry(submenu);
            return this;
        }

        public MenuEntryBuilder additionalCSS(Map<String, Boolean> additionalCSS) {
            this.entry.setAdditionalCSS(additionalCSS);
            return this;
        }

        public MenuEntryBuilder additionalCSS(String additionalCSS, boolean relative) {
            this.entry.addAdditionalCSS(additionalCSS, relative);
            return this;
        }

        public MenuEntryBuilder useCCSHierarchy(boolean useCCSHierarchy) {
            this.entry.setUseCCSHierarchy(useCCSHierarchy);
            return this;
        }

        public MenuEntryBuilder additionalJS(Map<String, Boolean> additionalJS) {
            this.entry.setAdditionalJS(additionalJS);
            return this;
        }

        public MenuEntryBuilder additionalJS(String additionalJS, boolean relative) {
            this.entry.addAdditionalJS(additionalJS, relative);
            return this;
        }

        public MenuEntryBuilder useJSHierarchy(boolean useJSHierarchy) {
            this.entry.setUseJSHierarchy(useJSHierarchy);
            return this;
        }

        public MenuEntryBuilder securityRoles(Set<String> securityRoles) {
            this.entry.setSecurityRoles(securityRoles);
            return this;
        }

        public MenuEntryBuilder securityRole(String securityRole) {
            this.entry.addSecurityRole(securityRole);
            return this;
        }

        public MenuEntryBuilder variables(Map<String, Object> variables) {
            this.entry.setVariables(variables);
            return this;
        }

        public MenuEntryBuilder variable(String key, Object variable) {
            this.entry.addVariable(key, variable);
            return this;
        }

        public MenuEntry build() {
            return this.entry;
        }
    }
}

