/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.core;

import de.chandre.admintool.core.AbstractAdminToolLoader;
import de.chandre.admintool.core.AdminTool;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="adminToolInitializer")
public class AdminToolInitializer
extends AbstractAdminToolLoader {
    private static final Log LOGGER = LogFactory.getLog(AdminToolInitializer.class);
    @Autowired
    private AdminTool adminTool;

    @PostConstruct
    public void init() {
        LOGGER.info((Object)"initializing AdminTool");
        boolean relative = !this.shouldCDNsUsed();
        String adminLtePrefix = this.getAdminLTEPrefixUri();
        this.adminTool.addGlobalStyleSheet(adminLtePrefix + "bootstrap/css/bootstrap.min.css", relative);
        this.adminTool.addGlobalStyleSheet(this.getWebjarsPrefixUri(this.coreConfig.isFontAwsomeCdnUseBower()) + "font-awesome/" + this.coreConfig.getFontAwsomeCdnVersion() + "/css/font-awesome.min.css", relative);
        this.adminTool.addGlobalStyleSheet(this.getWebjarsPrefixUri(this.coreConfig.isIonIconsCdnUseBower()) + "ionicons/" + this.coreConfig.getIonIconsCdnVersion() + "/css/ionicons.min.css", relative);
        if (StringUtils.isEmpty((Object)this.coreConfig.getJqueryPath())) {
            this.adminTool.addGlobalJavaScript(adminLtePrefix + this.coreConfig.getAdminLTEjqueryPath(), relative);
        } else {
            this.adminTool.addGlobalJavaScript(this.coreConfig.getJqueryPath(), relative);
        }
        this.adminTool.addGlobalJavaScript(adminLtePrefix + "bootstrap/js/bootstrap.min.js", relative);
        this.adminTool.addGlobalJavaScript(adminLtePrefix + "dist/js/app.min.js", relative);
        this.adminTool.addGlobalStyleSheet(adminLtePrefix + "dist/css/AdminLTE.min.css", relative);
        this.adminTool.addGlobalStyleSheet(adminLtePrefix + "dist/css/skins/skin-blue.min.css", relative);
        this.adminTool.addGlobalJavaScript("/static/admintool/js/adminTool.js", true);
        this.adminTool.addGlobalStyleSheet("/static/admintool/css/adminTool.css", true);
        this.adminTool.addGlobalJavaScript(adminLtePrefix + "plugins/datepicker/bootstrap-datepicker.js", relative);
        this.adminTool.addGlobalStyleSheet(adminLtePrefix + "plugins/datepicker/datepicker3.css", relative);
        this.adminTool.addGlobalJavaScript(adminLtePrefix + "plugins/timepicker/bootstrap-timepicker.min.js", relative);
        this.adminTool.addGlobalStyleSheet(adminLtePrefix + "plugins/timepicker/bootstrap-timepicker.min.css", relative);
        this.adminTool.addGlobalJavaScript(adminLtePrefix + "plugins/iCheck/icheck.min.js", relative);
        this.adminTool.addGlobalStyleSheet(adminLtePrefix + "plugins/iCheck/minimal/minimal.css", relative);
        this.adminTool.addGlobalJavaScript(adminLtePrefix + "plugins/datatables/jquery.dataTables.min.js", relative);
        this.adminTool.addGlobalStyleSheet(adminLtePrefix + "plugins/datatables/jquery.dataTables.min.css", relative);
    }
}

