/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.core;

import de.chandre.admintool.core.AdminToolCoreConfig;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractAdminToolLoader {
    @Autowired
    protected AdminToolCoreConfig coreConfig;

    protected boolean shouldCDNsUsed() {
        return this.coreConfig.isUseCDNs();
    }

    protected String getWebjarsPrefixUri(boolean useBower) {
        if (useBower) {
            return this.getWebjarsBowerPrefixUri();
        }
        return this.getWebjarsPrefixUri();
    }

    protected String getWebjarsPrefixUri() {
        if (this.coreConfig.isUseCDNs()) {
            return "https://cdn.jsdelivr.net/webjars/";
        }
        return "/webjars/";
    }

    protected String getWebjarsBowerPrefixUri() {
        if (this.coreConfig.isUseCDNs()) {
            return "https://cdn.jsdelivr.net/webjars/org.webjars.bower/";
        }
        return "/webjars/";
    }

    protected String getAdminLTEPrefixUri() {
        if (this.coreConfig.isUseCDNs()) {
            return "https://cdn.jsdelivr.net/webjars/org.webjars.bower/adminlte/" + this.coreConfig.getAdminLTECdnVersion() + "/";
        }
        return "/webjars/adminlte/" + this.coreConfig.getAdminLTECdnVersion() + "/";
    }
}

