/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.core.thymeleaf;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.resourceresolver.ClassLoaderResourceResolver;
import org.thymeleaf.resourceresolver.IResourceResolver;
import org.thymeleaf.util.ClassLoaderUtils;
import org.thymeleaf.util.Validate;

public class OrderedClassLoaderResourceResolver
implements IResourceResolver {
    private static final Log LOGGER = LogFactory.getLog(OrderedClassLoaderResourceResolver.class);
    public static final String NAME = "ADMINTOOL-CLASSLOADER";
    private Comparator<String> comparator;
    private boolean cacheEnabled;
    private Map<String, String> foundTemplateCache = new ConcurrentHashMap<String, String>();

    public OrderedClassLoaderResourceResolver() {
        this(null, true);
    }

    public OrderedClassLoaderResourceResolver(Comparator<String> templateUrlComparator) {
        this(templateUrlComparator, true);
    }

    public OrderedClassLoaderResourceResolver(Comparator<String> templateUrlComparator, boolean enableCaching) {
        this.comparator = templateUrlComparator;
        this.cacheEnabled = enableCaching;
    }

    public String getName() {
        return NAME;
    }

    public void clearCache() {
        this.foundTemplateCache.clear();
    }

    public InputStream getResourceAsStream(TemplateProcessingParameters templateProcessingParameters, String resourceName) {
        Validate.notNull((Object)resourceName, (String)"Resource name cannot be null");
        String urlToUse = null;
        if (this.cacheEnabled && null != (urlToUse = this.foundTemplateCache.get(resourceName))) {
            try {
                LOGGER.trace((Object)("returning remplate resource from cache: " + urlToUse));
                return this.getResourceAsStream(urlToUse);
            }
            catch (MalformedURLException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
        LOGGER.trace((Object)"============================================================");
        LOGGER.trace((Object)("try loading template resource: " + resourceName));
        ClassLoader loader = ClassLoaderUtils.getClassLoader(ClassLoaderResourceResolver.class);
        String pathToUse = resourceName;
        if (resourceName.startsWith("classpath:")) {
            pathToUse = pathToUse.substring("classpath:".length());
        }
        if ((pathToUse = StringUtils.cleanPath((String)pathToUse)).startsWith("/")) {
            pathToUse = pathToUse.substring(1);
        }
        try {
            TreeSet<String> urls;
            Enumeration<URL> resources = loader.getResources(pathToUse);
            TreeSet<String> treeSet = urls = null != this.comparator ? new TreeSet<String>(this.comparator) : new TreeSet();
            while (resources.hasMoreElements()) {
                String url = resources.nextElement().toString();
                LOGGER.trace((Object)("found: " + url.toString()));
                urls.add(url);
            }
            LOGGER.trace((Object)("resources count: " + (!urls.isEmpty() ? urls.size() : 0)));
            if (!urls.isEmpty()) {
                urlToUse = urls.first();
                this.foundTemplateCache.put(resourceName, urlToUse);
                LOGGER.trace((Object)("using remplate resource: " + urlToUse));
                return this.getResourceAsStream(urlToUse);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected InputStream getResourceAsStream(String paramString) throws MalformedURLException {
        URL localURL = new URL(paramString);
        try {
            if (null != localURL) {
                URLConnection localURLConnection = localURL.openConnection();
                return localURLConnection.getInputStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

