/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.core.controller;

import de.chandre.admintool.core.AdminToolCoreConfig;
import de.chandre.admintool.core.controller.AbstractAdminController;
import de.chandre.admintool.core.utils.ExceptionUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/admintool"})
public class AdminRootController
extends AbstractAdminController {
    private static final Log LOGGER = LogFactory.getLog(AdminRootController.class);
    @Autowired
    private AdminToolCoreConfig config;

    @RequestMapping(value={"", "/"})
    public String startPage(ModelMap model, HttpServletRequest request) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"serving admin root page");
        }
        this.addCommonContextVars(model, request);
        if (!this.config.isEnabled()) {
            return "admintool/deactivated";
        }
        model.put((Object)"contentPage", (Object)"admintool/content/start");
        return "admintool/content/start";
    }

    @RequestMapping(value={"/**"})
    public String subPage(ModelMap model, HttpServletRequest request) {
        String targetTpl = this.addCommonContextVars(model, request);
        if (!this.config.isEnabled()) {
            return "admintool/deactivated";
        }
        return "admintool/" + targetTpl;
    }

    @RequestMapping(value={"/{lang}/**"})
    public String subPageLang(ModelMap model, @PathVariable(value="lang") String language, HttpServletRequest request, HttpServletResponse response) {
        this.resolveLocale(language, request, response);
        String targetTpl = this.addCommonContextVars(model, request);
        if (!this.config.isEnabled()) {
            return "admintool/deactivated";
        }
        return "admintool/" + targetTpl;
    }

    @ExceptionHandler(value={Exception.class})
    public ModelAndView handleException(Exception exception, HttpServletRequest request) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("handleException: " + exception.getMessage()));
        }
        ModelAndView mv = new ModelAndView("admintool/content/error");
        this.addCommonContextVars(mv.getModelMap(), request);
        mv.getModelMap().put((Object)"exceptionMessage", (Object)exception.getMessage());
        mv.getModelMap().put((Object)"showStacktrace", (Object)this.config.isShowStacktraceOnErrorPage());
        mv.getModelMap().put((Object)"stacktrace", (Object)ExceptionUtils.printException(exception));
        return mv;
    }
}

