/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.core.controller;

import de.chandre.admintool.core.AdminTool;
import de.chandre.admintool.core.AdminToolCoreConfig;
import de.chandre.admintool.core.MenuEntrySearchResult;
import de.chandre.admintool.core.component.MenuEntry;
import de.chandre.admintool.core.utils.AdminToolMenuUtils;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.LocaleEditor;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.support.RequestContextUtils;

public class AbstractAdminController {
    private static final Log LOGGER = LogFactory.getLog(AbstractAdminController.class);
    @Autowired
    private AdminTool adminTool;
    @Autowired
    private AdminToolMenuUtils menuUtils;
    @Autowired
    private AdminToolCoreConfig coreConfig;

    protected String addCommonContextVars(ModelMap model, HttpServletRequest request) {
        return this.addCommonContextVars(model, request, null, null);
    }

    protected String addCommonContextVars(ModelMap model, HttpServletRequest request, String overrideName, String overrideTarget) {
        String targetTpl;
        LOGGER.debug((Object)String.format("receiving request: ctxPath: %s, uri: %s", request.getContextPath(), request.getRequestURI()));
        String name = this.menuUtils.getMenuName(request, overrideName);
        MenuEntrySearchResult result = this.adminTool.searchComponent(name);
        model.put((Object)"internationalizationEnabled", (Object)this.coreConfig.isInternationalizationEnabled());
        model.put((Object)"rootContext", (Object)this.getRootContext(request));
        model.put((Object)"adminToolContext", (Object)"/admintool");
        String string = targetTpl = this.coreConfig.isEnabled() ? "content/error404" : "deactivated";
        if (null != result) {
            MenuEntrySearchResult overriddenResult;
            LOGGER.trace((Object)("Component found: " + String.valueOf(null != result.getComponent()) + " | menu found: " + String.valueOf(result.getMenuEntry())));
            model.put((Object)"menuEntrySearchResult", (Object)result);
            MenuEntry entry = result.getMenuEntry();
            targetTpl = StringUtils.isEmpty((Object)overrideTarget) ? entry.getTarget() : AdminToolMenuUtils.normalizeTarget(overrideTarget);
            model.put((Object)"contentPage", (Object)("admintool/" + targetTpl));
            if (null != entry.getVariables()) {
                model.putAll(entry.getVariables());
            }
            model.put((Object)"activeMenu", (Object)entry);
            String overriddenActive = entry.getActiveName();
            if (!StringUtils.isEmpty((Object)overriddenActive) && null != (overriddenResult = this.adminTool.searchComponent(overriddenActive))) {
                model.put((Object)"activeMenu", (Object)overriddenResult.getMenuEntry());
            }
        } else {
            model.put((Object)"contentPage", (Object)("admintool/" + targetTpl));
        }
        return targetTpl;
    }

    protected String getRootContext(HttpServletRequest request) {
        if (StringUtils.isEmpty((Object)this.coreConfig.getStripRootContext())) {
            return request.getContextPath() + "/admintool";
        }
        return request.getContextPath().replaceFirst(Pattern.quote(this.coreConfig.getStripRootContext()), "") + "/admintool";
    }

    protected void resolveLocale(String language, HttpServletRequest request, HttpServletResponse response) {
        LocaleEditor localeEditor = new LocaleEditor();
        localeEditor.setAsText(language);
        this.resolveLocale((Locale)localeEditor.getValue(), request, response);
    }

    protected void resolveLocale(Locale language, HttpServletRequest request, HttpServletResponse response) {
        LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver((HttpServletRequest)request);
        localeResolver.setLocale(request, response, language);
    }
}

